package com.libawall.api.enums;

public enum IsLeaderEnum {
    NO(0, "否"),
    YES(1,"是"),
    ;

    private Integer code;

    private String desc;

    public static IsLeaderEnum getInstance(Integer code) {
        if (code == null) {
            return null;
        }
        for (IsLeaderEnum statusEnum : IsLeaderEnum.values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }

    IsLeaderEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
