package com.libawall.api.enums;

import java.util.Arrays;

/**
 * 设备蘸墨加墨
 */
public enum EquipmentTypeEnum {

    WITH_INK(1, "沾墨"),
    MISTAKE_WITH_INK(2, "非沾墨"),
    ;

    private final Integer code;

    private final String desc;

    EquipmentTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据code获取枚举
     *
     * @param code      code
     * @return          instance
     */
    public static EquipmentTypeEnum getInstance(Integer code) {
        return Arrays.stream(EquipmentTypeEnum.values()).filter(element -> element.getCode().equals(code))
                .findFirst()
                .orElse(null);
    }

    /**
     * 根据desc获取枚举
     *
     * @param desc      desc
     * @return          instance
     */
    public static EquipmentTypeEnum getInstance(String desc) {
        return Arrays.stream(EquipmentTypeEnum.values()).filter(equipmentModelEnum -> equipmentModelEnum.getDesc().equals(desc))
                .findFirst()
                .orElse(null);
    }


    /**
     * 判断是否存在指定状态码的枚举
     *
     * @param code      状态码
     * @return          存在true，否则false
     */
    public static Boolean exists(Integer code) {
        return Arrays.stream(EquipmentTypeEnum.values()).anyMatch(element -> element.getCode().equals(code));
    }

    /**
     * 判断是否存在指定描述的枚举
     *
     * @param desc      状态码
     * @return          存在true，否则false
     */
    public static Boolean exists(String desc) {
        return Arrays.stream(EquipmentTypeEnum.values()).anyMatch(element -> element.getDesc().equals(desc));
    }

}
