package com.libawall.api.enums;

/**
 * 审批人状态
 */
public enum DocumentViceApproverStateEnum {
    APPROVER_STATE_AGREE(3,"同意"),
    APPROVER_STATE_REFUSE(4,"拒绝"),
    ;

    private final Integer code;

    private final String desc;

    public static DocumentViceApproverStateEnum getInstance(Integer code) {
        if (code == null){ return null;}
        for (DocumentViceApproverStateEnum statusEnum: DocumentViceApproverStateEnum.values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }

    DocumentViceApproverStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
