package com.libawall.api.enums;


/**
 *文件盖印人表 盖印人类型
 **/
public enum DocumentSealStaffRelTypeEnum {
    AFFIX_STAFF(1, "用印盖印人"),
    COVER_STAFF(2, "补盖盖印人"),
    ;


    private final Integer code;

    private final String desc;

    public static DocumentSealStaffRelTypeEnum getInstance(Integer code) {
        if (code == null) {
            return null;
        }
        for (DocumentSealStaffRelTypeEnum statusEnum : DocumentSealStaffRelTypeEnum.values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }

    DocumentSealStaffRelTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}