package com.libawall.api.enums;


import java.util.Arrays;

/**
 * 附件二维码-渲染类型
 */
public enum DocumentFileQrcodePageTypeEnum{

    HOME_PAGE(1, "单文件"),
    PER_PAGE(2, "单页"),
    ;

    private final Integer code;
    private final String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    DocumentFileQrcodePageTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DocumentFileQrcodePageTypeEnum getInstance(Integer code) {
        return Arrays.stream(DocumentFileQrcodePageTypeEnum.values()).filter(item -> item.getCode().equals(code))
                .findFirst()
                .orElse(null);
    }
}
