package com.libawall.api.document.response;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 根据用印文件id获取文件地址
 */
public class DocumentFileDetailsResponse implements Serializable {

    /**
     * 文件id
     */
    private Long documentId;

    /**
     * 文件名字
     */
    private String fileName;

    /**
     * 用印类型
     */
    private Integer status;

    /**
     * 盖印人用户名
     */
    private String staffName;

    /**
     * 盖印人用户id
     */
    private Long staffId;


    /**
     * 盖印时间
     */
    private LocalDateTime sealTime;


    /**
     * 用印影像
     */
    private Long fileId;

    /**
     * 用印影像地址
     */
    private String fullFile;


    /**
     * 经度
     */
    private String lon;

    /**
     * 纬度
     */
    private String lat;

    /**
     * 盖印的具体位置信息
     */
    private String address;

    /**
     * 图片类型 1用印图片 2补拍图片3补盖图片
     */
    private Integer imageType;

    /**
     * 是否开启影像管理  0:开启 1.关闭
     */
    private Integer pictureType;

    /**
     * 是否抓拍成功 1、影像成功 2、抓拍失败
     */
    private Integer photoType;

    /**
     * 影像上传设备 1、A或APlus 2、简易款 3、手机 4、高拍仪
     */
    private Integer deviceType;


    public Long getDocumentId() {
        return documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public LocalDateTime getSealTime() {
        return sealTime;
    }

    public void setSealTime(LocalDateTime sealTime) {
        this.sealTime = sealTime;
    }

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public String getFullFile() {
        return fullFile;
    }

    public void setFullFile(String fullFile) {
        this.fullFile = fullFile;
    }

    public String getLon() {
        return lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getImageType() {
        return imageType;
    }

    public void setImageType(Integer imageType) {
        this.imageType = imageType;
    }

    public Integer getPictureType() {
        return pictureType;
    }

    public void setPictureType(Integer pictureType) {
        this.pictureType = pictureType;
    }

    public Integer getPhotoType() {
        return photoType;
    }

    public void setPhotoType(Integer photoType) {
        this.photoType = photoType;
    }

    public Integer getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }
}
