package com.libawall.api.document.request;

import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 远程审批状态上传
 */
public class DocumentRemoteViceUpdateRequest implements JsonSdkRequest<BaseResponse<Boolean>> {
    /**
     * 文件id
     */
    private Long documentRemoteViceId;

    /**
     * 当前审批人的状态 1同意、2拒绝
     */
    private Integer state;

    /**
     * 远程审批人id
     */
    private Long remoteStaffId;

    public Long getDocumentRemoteViceId() {
        return documentRemoteViceId;
    }

    public void setDocumentRemoteViceId(Long documentRemoteViceId) {
        this.documentRemoteViceId = documentRemoteViceId;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Long getRemoteStaffId() {
        return remoteStaffId;
    }

    public void setRemoteStaffId(Long remoteStaffId) {
        this.remoteStaffId = remoteStaffId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/examine/remote/upload";
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.PUT;
    }
}
