package com.libawall.api.document.request;


import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.document.response.DocumentRemoteBusinessIdReqponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * 发起远程审批
 */
public class DocumentRemoteViceAddRequest implements JsonSdkRequest<BaseResponse<DocumentRemoteBusinessIdReqponse>> {
    /**
     * 文件id
     */
    private Long documentId;

    /**
     * 用户id
     */
    private Long staffId;

    /**
     * 审批图片id
     */
    private List<Long> fileId;

    /**
     * 印章id
     */
    private Long sealId;

    /**
     * 设备id
     */
    private String deviceId;

    /**
     * 远程审批id,根据时间戳生成的唯一id
     */
    private Long documentRemoteViceId;

    public Long getDocumentId() {
        return documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public List<Long> getFileId() {
        return fileId;
    }

    public void setFileId(List<Long> fileId) {
        this.fileId = fileId;
    }

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Long getDocumentRemoteViceId() {
        return documentRemoteViceId;
    }

    public void setDocumentRemoteViceId(Long documentRemoteViceId) {
        this.documentRemoteViceId = documentRemoteViceId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/examine/remote";
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }
}
