package com.libawall.api.document.request;


import com.libawall.api.document.response.DocumentApplyResponse;
import com.libawall.api.util.PageResponse;
import com.libawall.api.util.PaginationQuery;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;


/**
 * 待用印页面展示
 */
public class DocumentRecordQueryRequest extends PaginationQuery implements SdkRequest<PageResponse<DocumentApplyResponse>> {

    /**
     * 用户id
     */
    private Long staffId;

    /**
     * 不传值为全部 1、特权用印和 2、普通用印
     */
    private Integer status;

    /**
     * 模糊查询
     */
    private String search;

    /**
     * 申请|盖印时间区间筛选-开始 yyyy-mm-dd
     */
    private String startTime;

    /**
     * 申请|盖印时间区间筛选-结束 yyyy-mm-dd
     */
    private String endTime;

    /**
     * 为空倒叙,1为正序排列
     */
    private Integer timeSort;

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSearch() {
        return search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getTimeSort() {
        return timeSort;
    }

    public void setTimeSort(Integer timeSort) {
        this.timeSort = timeSort;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/document/record/show";
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
