package com.libawall.api.document.request;

import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.document.response.DocumentDetailsResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;


/**
 * 用印查看详情
 */
public class DocumentDetailsRequest implements JsonSdkRequest<BaseResponse<DocumentDetailsResponse>> {

    /**
     * 文件id
     */
    private final transient Long documentId;

    public DocumentDetailsRequest(Long documentId) {
        this.documentId = documentId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/document/details/v3.4.0/"+documentId;
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
