package com.libawall.api.department.request;


import com.libawall.api.department.response.DepartmentResponse;
import com.libawall.api.util.PageResponse;
import com.libawall.api.util.PaginationQuery;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 部门分页查询
 */
public class DepartmentQueryRequest extends PaginationQuery implements SdkRequest<PageResponse<DepartmentResponse>> {

    /**
     * 模糊查询部门名称
     */
    private String searchDepartmentName;

    /**
     * 根据创建时间排序
     */
    private Boolean orderByCreateTime;

    public String getSearchDepartmentName() {
        return searchDepartmentName;
    }

    public void setSearchDepartmentName(String searchDepartmentName) {
        this.searchDepartmentName = searchDepartmentName;
    }

    public Boolean getOrderByCreateTime() {
        return orderByCreateTime;
    }

    public void setOrderByCreateTime(Boolean orderByCreateTime) {
        this.orderByCreateTime = orderByCreateTime;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/department";
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
