package com.libawall.api.department.request;

import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * @description 部门删除
 **/
public class DepartmentDeleteRequest implements JsonSdkRequest<BaseResponse<Boolean>> {

    /**
     * 部门id不能为空
     */
    private final transient Long departmentId;

    public DepartmentDeleteRequest(Long departmentId){
        this.departmentId = departmentId;
    }


    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/department/"+ departmentId;
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.DELETE;
    }
}
