package com.libawall.api.department.request;

import com.alibaba.fastjson.JSONArray;
import com.libawall.api.department.response.DepartmentIdResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.MuiltSdkRequest;
import com.libawall.api.util.SdkRequest;

import com.libawall.util.httpclient.RequestMethod;

import java.util.ArrayList;
import java.util.List;

/**
 * 第三方部门批量添加参数
 */
public class DepartmentBatchAddRequest implements MuiltSdkRequest<BaseResponse<List<DepartmentIdResponse>>, DepartmentBatchAddInfo> {


    private List<DepartmentBatchAddInfo> departmentAddDTO;

    public List<DepartmentBatchAddInfo> getDepartmentAddDTO() {
        return departmentAddDTO;
    }

    public void setDepartmentAddDTO(List<DepartmentBatchAddInfo> departmentAddDTO) {
        this.departmentAddDTO = departmentAddDTO;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/department/batch";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }


    @Override
    public List<DepartmentBatchAddInfo> getMulitList() {
        return departmentAddDTO;
    }
}
