package com.libawall.api.department.request;

import com.libawall.api.department.response.DepartmentIdResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;

import com.libawall.util.httpclient.RequestMethod;

/**
 * 第三方部门添加参数
 */
public class DepartmentAddRequest implements SdkRequest<BaseResponse<DepartmentIdResponse>> {

    /**
     * 部门名称
     */
    private String departmentName;

    /**
     * 父级部门id（顶级部门id的父id是0）
     */
    private Long parentId;

    /**
     * 主管id
     */
    private Long leaderId;

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getLeaderId() {
        return leaderId;
    }

    public void setLeaderId(Long leaderId) {
        this.leaderId = leaderId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/department";
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }
}
