package com.libawall.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.libawall.api.util.ClassGenricTypeBeanUtils;
import com.libawall.api.util.JsonSdkRequest;
import com.libawall.api.util.MuiltSdkRequest;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.HttpClientUtil;
import com.libawall.util.httpclient.HttpParam;
import com.libawall.util.httpclient.HttpResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/**
 * 请求客户端
 */
public class YDAClient {
    private static final Logger log = LoggerFactory.getLogger(YDAClient.class);

    private String token;

    private String url;

    /**
     * 子企业id
     */
    @Deprecated
    private Long deputyId;

    /**
     * 企业获取token
     */
    public YDAClient() {
    }

    /**
     * 企业请求器
     *
     * @param token token
     */
    public YDAClient(String token) {
        this.token = token;
    }

    /**
     * 企业请求器
     *
     * @param url   请求地址
     * @param token token
     */
    public YDAClient(String url, String token) {
        this.token = token;
        this.url = url;
    }


    /**
     * 子企业请求器
     *
     * @param url      请求地址
     * @param token    token
     * @param deputyId 子企业id
     */
    @Deprecated
    public YDAClient(String url, String token, Long deputyId) {
        this.url = url;
        this.token = token;
        this.deputyId = deputyId;
    }

    /**
     * 子企业请求器
     *
     * @param token    token
     * @param deputyId 子企业id
     */
    @Deprecated
    public YDAClient(String token, Long deputyId) {
        this.token = token;
        this.deputyId = deputyId;
    }

    /**
     * 执行器
     */
    public <T> T service(SdkRequest<T> req) {
        String requestUrl = (StringUtils.isBlank(url) ? Constants.URL : url) + req.getUrl();

        if(deputyId != null) {
            if (requestUrl.contains("?")) {
                requestUrl += "&deputyId=" + deputyId;
            } else {
                requestUrl += "?deputyId=" + deputyId;
            }
        }

        HttpParam httpParam = new HttpParam();
        httpParam.setMethod(req.getMethod());
        httpParam.setUrl(requestUrl);

        if (req instanceof MuiltSdkRequest) {
            String jsonString = JSON.toJSONString(((MuiltSdkRequest<?, ?>) req).getMulitList());
            httpParam.setEntity(new StringEntity(jsonString, ContentType.APPLICATION_JSON));
        } else if (req instanceof JsonSdkRequest) {
            String jsonString = JSON.toJSONString(req);
            httpParam.setEntity(new StringEntity(jsonString, ContentType.APPLICATION_JSON));
        } else {
            httpParam.addParam(beanToMap(req));
        }

        if (StringUtils.isNotBlank(token)) {
            httpParam.addHeader("Authorization", "Bearer " + token);
        }

        httpParam.addHeader("sdk_version", Constants.SDK_VERSION);
        HttpResult request = HttpClientUtil.request(httpParam);
        String body = request.getContext();

        if (!request.isSuccess()) {
            JSONObject jsonObject = JSONObject.parseObject(body);
            if (jsonObject != null && jsonObject.containsKey("error")) {
                jsonObject.put("message", jsonObject.getString("error_description"));
                jsonObject.put("code", -1);
            }else {
                jsonObject = new JSONObject();
                jsonObject.put("message", "请求异常");
                jsonObject.put("code", request.getStatusLine().getStatusCode());
            }
            jsonObject.put("success", false);
            body = jsonObject.toJSONString();
        }
        log.debug(body);
        Type interfacesGenricType = ClassGenricTypeBeanUtils.getInterfacesGenricType(req.getClass(), SdkRequest.class, 0);
        return JSON.parseObject(body, interfacesGenricType);
    }


    /**
     * 获取bean字段内的值
     *
     * @param bean
     * @return
     */
    public static Map<String, Object> beanToMap(Object bean) {
        Map<String, Object> map = new HashMap<>();
        // 获取类的所有字段（包括父类的字段）
        Field[] fields = FieldUtils.getAllFields(bean.getClass());
        for (Field field : fields) {
            field.setAccessible(true);
            // 如果字段是子类类型，递归调用beanToMap方法来转换为Map对象
            try {
                map.put(field.getName(), field.get(bean));
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }
}
