/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.face_detection.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.face_detection.v1.model.DetectFaceAttributesImageReq;
import com.lark.oapi.service.face_detection.v1.model.DetectFaceAttributesImageResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceDetectionService {
    private static final Logger log = LoggerFactory.getLogger(FaceDetectionService.class);
    private final Image image;

    public FaceDetectionService(Config config) {
        this.image = new Image(config);
    }

    public Image image() {
        return this.image;
    }

    public static class Image {
        private final Config config;

        public Image(Config config) {
            this.config = config;
        }

        public DetectFaceAttributesImageResp detectFaceAttributes(DetectFaceAttributesImageReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DetectFaceAttributesImageResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/face_detection/v1/image/detect_face_attributes", Sets.newHashSet(AccessTokenType.Tenant), req), DetectFaceAttributesImageResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/face_detection/v1/image/detect_face_attributes", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DetectFaceAttributesImageResp detectFaceAttributes(DetectFaceAttributesImageReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/face_detection/v1/image/detect_face_attributes", Sets.newHashSet(AccessTokenType.Tenant), req);
            DetectFaceAttributesImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DetectFaceAttributesImageResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/face_detection/v1/image/detect_face_attributes", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

