/*
 * Decompiled with CFR 0.152.
 */
package com.justtoplay.xxl.job.plus.discovery.nacos;

import com.alibaba.boot.nacos.discovery.properties.NacosDiscoveryProperties;
import com.alibaba.boot.nacos.discovery.properties.Register;
import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.utils.NetUtils;
import com.justtoplay.xxl.job.plus.discovery.nacos.NamingServiceHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(value={NamingServiceHolder.class})
public class DefaultNamingServiceHolder
implements NamingServiceHolder {
    @NacosInjected
    private NamingService namingService;
    @Autowired
    private NacosDiscoveryProperties discoveryProperties;
    @Value(value="${spring.application.name:}")
    private String applicationName;
    @Value(value="${server.port}")
    private Integer port;

    @Override
    public NamingService get() {
        return this.namingService;
    }

    @Override
    public String getExecutorAddress() {
        Register register = this.discoveryProperties.getRegister();
        if (StringUtils.isEmpty((CharSequence)register.getIp())) {
            register.setIp(NetUtils.localIP());
        }
        if (register.getPort() == 0) {
            register.setPort(this.port.intValue());
        }
        return register.getIp() + ":" + register.getPort();
    }

    @Override
    public String getServiceName() {
        String serviceName = this.discoveryProperties.getRegister().getServiceName();
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            serviceName = this.applicationName;
        }
        return serviceName;
    }
}

