/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.http;

import com.jdcloud.sdk.http.Protocol;

public interface HttpRequestConfig {
    public int getConnectionTimeout();

    public int getSocketTimeout();

    public int getMaxTotal();

    public int getMaxConnPerRoute();

    public boolean getTcpNoDelay();

    public int getReadTimeout();

    public int getValidateAfterInactivity();

    public Protocol getProtocol();

    public Protocol getProxyProtocol();

    public String getProxyHost();

    public int getProxyPort();

    public static class Builder {
        private DefaultHttpRequestConfig config = new DefaultHttpRequestConfig();

        public Builder connectionTimeout(int timeout) {
            this.config.connectionTimeout = timeout;
            return this;
        }

        public Builder socketTimeout(int timeout) {
            this.config.socketTimeout = timeout;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.config.protocol = protocol;
            return this;
        }

        public Builder proxyProtocol(Protocol proxyProtocol) {
            this.config.proxyProtocol = proxyProtocol;
            return this;
        }

        public Builder readTimeout(int timeout) {
            this.config.readTimeout = timeout;
            return this;
        }

        public Builder validateAfterInactivity(int validateAfterInactivity) {
            if (validateAfterInactivity > 0) {
                this.config.validateAfterInactivity = validateAfterInactivity;
            }
            return this;
        }

        public Builder tcpNoDelay(boolean tcpNoDelay) {
            this.config.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public Builder maxConnPerRoute(int maxConnPerRoute) {
            this.config.maxConnPerRoute = maxConnPerRoute;
            return this;
        }

        public Builder maxTotal(int maxTotal) {
            this.config.maxTotal = maxTotal;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.config.proxyHost = proxyHost;
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.config.proxyPort = proxyPort;
            return this;
        }

        public HttpRequestConfig build() {
            return this.config;
        }

        private static class DefaultHttpRequestConfig
        implements HttpRequestConfig {
            private int connectionTimeout = -1;
            private int socketTimeout = -1;
            private Protocol protocol = Protocol.HTTPS;
            private Protocol proxyProtocol = Protocol.HTTP;
            private String proxyHost = null;
            private int proxyPort = -1;
            private int maxTotal;
            private int maxConnPerRoute;
            private boolean tcpNoDelay;
            private int readTimeout = -1;
            private int validateAfterInactivity = 2000;

            private DefaultHttpRequestConfig() {
            }

            @Override
            public int getReadTimeout() {
                return this.readTimeout;
            }

            @Override
            public int getMaxTotal() {
                return this.maxTotal;
            }

            @Override
            public int getMaxConnPerRoute() {
                return this.maxConnPerRoute;
            }

            @Override
            public boolean getTcpNoDelay() {
                return this.tcpNoDelay;
            }

            @Override
            public int getConnectionTimeout() {
                return this.connectionTimeout;
            }

            @Override
            public int getValidateAfterInactivity() {
                return this.validateAfterInactivity;
            }

            @Override
            public int getSocketTimeout() {
                return this.socketTimeout;
            }

            @Override
            public Protocol getProtocol() {
                return this.protocol;
            }

            @Override
            public Protocol getProxyProtocol() {
                return this.proxyProtocol;
            }

            @Override
            public String getProxyHost() {
                return this.proxyHost;
            }

            @Override
            public int getProxyPort() {
                return this.proxyPort;
            }
        }
    }
}

