/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.auth.sign;

import com.jdcloud.sdk.auth.Credentials;
import com.jdcloud.sdk.auth.SessionCredentials;
import com.jdcloud.sdk.auth.sign.ProgressInputStream;
import com.jdcloud.sdk.auth.sign.SdkDigestInputStream;
import com.jdcloud.sdk.auth.sign.Signer;
import com.jdcloud.sdk.auth.sign.SigningAlgorithm;
import com.jdcloud.sdk.client.SdkClientException;
import com.jdcloud.sdk.http.SdkHttpFullRequest;
import com.jdcloud.sdk.utils.Base64Utils;
import com.jdcloud.sdk.utils.BinaryUtils;
import com.jdcloud.sdk.utils.SdkHttpUtils;
import com.jdcloud.sdk.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractSigner
implements Signer {
    public static final String EMPTY_STRING_SHA256_HEX;
    private static final ThreadLocal<MessageDigest> SHA256_MESSAGE_DIGEST;

    private static byte[] doHash(String text) throws SdkClientException {
        try {
            MessageDigest md = AbstractSigner.getMessageDigestInstance();
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    private static MessageDigest getMessageDigestInstance() {
        MessageDigest messageDigest = SHA256_MESSAGE_DIGEST.get();
        messageDigest.reset();
        return messageDigest;
    }

    protected String signAndBase64Encode(String data, String key, SigningAlgorithm algorithm) throws SdkClientException {
        return this.signAndBase64Encode(data.getBytes(StandardCharsets.UTF_8), key, algorithm);
    }

    private String signAndBase64Encode(byte[] data, String key, SigningAlgorithm algorithm) throws SdkClientException {
        try {
            byte[] signature = this.sign(data, key.getBytes(StandardCharsets.UTF_8), algorithm);
            return Base64Utils.encodeAsString(signature);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public byte[] signWithMac(String stringData, Mac mac) {
        try {
            return mac.doFinal(stringData.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public byte[] sign(String stringData, byte[] key, SigningAlgorithm algorithm) throws SdkClientException {
        try {
            byte[] data = stringData.getBytes(StandardCharsets.UTF_8);
            return this.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws SdkClientException {
        try {
            Mac mac = algorithm.getMac();
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public byte[] hash(String text) throws SdkClientException {
        return AbstractSigner.doHash(text);
    }

    protected byte[] hash(InputStream input) throws SdkClientException {
        try {
            MessageDigest md = AbstractSigner.getMessageDigestInstance();
            SdkDigestInputStream digestInputStream = new SdkDigestInputStream(input, md);
            byte[] buffer = new byte[1024];
            while (digestInputStream.read(buffer) > -1) {
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    public byte[] hash(byte[] data) throws SdkClientException {
        try {
            MessageDigest md = AbstractSigner.getMessageDigestInstance();
            md.update(data);
            return md.digest();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    protected String getCanonicalizedQueryString(Map<String, List<String>> parameters) {
        TreeMap sorted = new TreeMap();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            String encodedParamName = SdkHttpUtils.urlEncode(entry.getKey(), false);
            List<String> paramValues = entry.getValue();
            ArrayList<String> encodedValues = new ArrayList<String>(paramValues.size());
            for (String value : paramValues) {
                encodedValues.add(SdkHttpUtils.urlEncode(value, false));
            }
            Collections.sort(encodedValues);
            sorted.put(encodedParamName, encodedValues);
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : sorted.entrySet()) {
            for (String value : (List)entry.getValue()) {
                if (result.length() > 0) {
                    result.append("&");
                }
                result.append((String)entry.getKey()).append("=").append(value);
            }
        }
        return result.toString();
    }

    protected InputStream getBinaryRequestPayloadStream(InputStream wrapped) {
        try {
            InputStream unwrapped = this.getContentUnwrapped(wrapped);
            if (unwrapped == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (!unwrapped.markSupported()) {
                throw new SdkClientException("Unable to read request payload to sign request.");
            }
            return unwrapped;
        }
        catch (SdkClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to read request payload to sign request: " + e.getMessage(), e);
        }
    }

    private InputStream getContentUnwrapped(InputStream is) {
        if (is == null) {
            return null;
        }
        while (is instanceof ProgressInputStream) {
            ProgressInputStream pris = (ProgressInputStream)is;
            is = pris.getWrappedInputStream();
        }
        return is;
    }

    protected String getCanonicalizedResourcePath(String resourcePath, boolean urlEncode) {
        String value;
        if (resourcePath == null || resourcePath.isEmpty()) {
            return "/";
        }
        String string = value = urlEncode ? SdkHttpUtils.urlEncode(resourcePath, true) : resourcePath;
        if (value.startsWith("/")) {
            return value;
        }
        return "/".concat(value);
    }

    protected String getCanonicalizedEndpoint(URI endpoint) {
        String endpointForStringToSign = StringUtils.lowerCase(endpoint.getHost());
        if (SdkHttpUtils.isUsingNonDefaultPort(endpoint)) {
            endpointForStringToSign = endpointForStringToSign + ":" + endpoint.getPort();
        }
        return endpointForStringToSign;
    }

    protected Credentials sanitizeCredentials(Credentials credentials) {
        String accessKeyId = StringUtils.trim(credentials.accessKeyId());
        String secretKey = StringUtils.trim(credentials.secretAccessKey());
        if (credentials instanceof SessionCredentials) {
            SessionCredentials sessionCredentials = (SessionCredentials)credentials;
            return new SessionCredentials(accessKeyId, secretKey, StringUtils.trim(sessionCredentials.sessionToken()));
        }
        return credentials;
    }

    protected Date getSignatureDate(int offsetInSeconds) {
        return new Date(System.currentTimeMillis() - 1000L * (long)offsetInSeconds);
    }

    protected abstract void addSessionCredentials(SdkHttpFullRequest.Builder var1, SessionCredentials var2);

    static {
        SHA256_MESSAGE_DIGEST = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance("SHA-256");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new SdkClientException("Unable to get SHA256 Function" + e.getMessage(), e);
                }
            }
        };
        EMPTY_STRING_SHA256_HEX = BinaryUtils.toHex(AbstractSigner.doHash(""));
    }
}

