/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.jdcloud.sdk.auth.CredentialsProvider;
import com.jdcloud.sdk.client.Environment;
import com.jdcloud.sdk.client.JdcloudHttpResponseInterceptor;
import com.jdcloud.sdk.http.HttpRequestConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.params.HttpParams;

public abstract class JdcloudClient {
    public static final String JSON = "application/json";
    HttpTransport httpTransport = new ApacheHttpTransport();
    HttpRequestFactory httpRequestFactory;
    private Map<String, String> customHeader = new HashMap<String, String>();
    private boolean retryQuest = true;
    private static final Feature[] FEATURES = new Feature[]{Feature.AutoCloseSource, Feature.UseBigDecimal, Feature.AllowUnQuotedFieldNames, Feature.AllowSingleQuotes, Feature.AllowArbitraryCommas, Feature.AllowArbitraryCommas, Feature.SortFeidFastMatch, Feature.IgnoreNotMatch, Feature.DisableSpecialKeyDetect};

    void init() {
        final HttpRequestConfig httpRequestConfig = this.getHttpRequestConfig();
        if (httpRequestConfig != null && httpRequestConfig.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(httpRequestConfig.getProxyHost(), httpRequestConfig.getProxyPort(), httpRequestConfig.getProxyProtocol().toString());
            boolean staleConnectionCheck = this.getHttpConnectionParams().getBooleanParameter("http.connection.stalecheck", false);
            boolean tcpNodelay = this.getHttpConnectionParams().getBooleanParameter("http.tcp.nodelay", false);
            this.httpTransport = new ApacheHttpTransport.Builder().setProxy(proxy).build();
            this.getHttpConnectionParams().setBooleanParameter("http.connection.stalecheck", staleConnectionCheck);
            this.getHttpConnectionParams().setBooleanParameter("http.tcp.nodelay", tcpNodelay);
        }
        this.httpRequestFactory = this.httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                if (httpRequestConfig != null) {
                    if (httpRequestConfig.getConnectionTimeout() != -1) {
                        request.setConnectTimeout(httpRequestConfig.getConnectionTimeout());
                    }
                    if (httpRequestConfig.getSocketTimeout() != -1) {
                        request.setReadTimeout(httpRequestConfig.getSocketTimeout());
                    }
                }
            }
        });
    }

    public HttpParams getHttpConnectionParams() {
        return ((ApacheHttpTransport)this.httpTransport).getHttpClient().getParams();
    }

    public void setStaleCheckingEnabled(boolean enabled) {
        ((ApacheHttpTransport)this.httpTransport).getHttpClient().getParams().setBooleanParameter("http.connection.stalecheck", enabled);
    }

    public void setTcpNoDelay(boolean enabled) {
        ((ApacheHttpTransport)this.httpTransport).getHttpClient().getParams().setBooleanParameter("http.tcp.nodelay", enabled);
    }

    HttpRequest buildRequest(String requestMethod, GenericUrl url, HttpContent content) throws IOException {
        return this.httpRequestFactory.buildRequest(requestMethod, url, content).setResponseInterceptor((HttpResponseInterceptor)new JdcloudHttpResponseInterceptor());
    }

    <T> T readValue(InputStream src, Class<T> valueType) throws IOException {
        if (src == null) {
            return null;
        }
        return (T)com.alibaba.fastjson.JSON.parseObject((InputStream)src, valueType, (Feature[])FEATURES);
    }

    <T> T readValue(byte[] src, Class<T> valueType) throws IOException {
        if (src == null) {
            return null;
        }
        return (T)com.alibaba.fastjson.JSON.parseObject((byte[])src, valueType, (Feature[])FEATURES);
    }

    <T> T readValue(String text, Class<T> valueType) {
        return (T)com.alibaba.fastjson.JSON.parseObject((String)text, valueType, (Feature[])FEATURES);
    }

    String getEndpoint() {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return environment.getEndpoint();
        }
        return null;
    }

    String getRealEndPoints() {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return environment.getRealEndPoints();
        }
        return null;
    }

    public abstract CredentialsProvider getCredentialsProvider();

    public abstract HttpRequestConfig getHttpRequestConfig();

    public abstract Environment getEnvironment();

    public abstract String getUserAgent();

    public abstract String getServiceName();

    public abstract String getVersion();

    public void setCustomHeader(String key, String value) {
        this.customHeader.put(key, value);
    }

    public Map<String, String> getCustomHeader() {
        return this.customHeader;
    }

    public boolean isRetryQuest() {
        return this.retryQuest;
    }

    public void setRetryQuest(boolean retryQuest) {
        this.retryQuest = retryQuest;
    }
}

