/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.classic;

import utils.security.SpecificationException;

public class SSHKeyReader {
    private byte[] input;
    private int pos = 0;
    private byte[] magic;

    public SSHKeyReader(byte[] magicBytes, byte[] keyBytes) {
        this.magic = magicBytes;
        this.input = keyBytes;
        for (int i = 0; i < this.magic.length; ++i) {
            if (this.magic[i] == keyBytes[i]) continue;
            throw new SpecificationException("Magic bytes are inconsistent!");
        }
        this.pos += this.magic.length;
    }

    public SSHKeyReader(byte[] keyBytes) {
        this.magic = null;
        this.input = keyBytes;
    }

    public int read32Bits() {
        return (this.input[this.pos++] & 0xFF) << 24 | (this.input[this.pos++] & 0xFF) << 16 | (this.input[this.pos++] & 0xFF) << 8 | this.input[this.pos++] & 0xFF;
    }

    public byte[] readBytes() {
        int count = this.read32Bits();
        byte[] result = new byte[count];
        System.arraycopy(this.input, this.pos, result, 0, result.length);
        this.pos += count;
        return result;
    }

    public byte[] getMagic() {
        return this.magic;
    }
}

