/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.classic;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemReader;
import utils.crypto.classic.SSHKeyReader;
import utils.io.RuntimeIOException;
import utils.security.SpecificationException;

public class SSHKeyParser {
    private String keyFormat;
    private String keyType;
    private String identity;

    public AsymmetricKeyParameter pubKeyParse(String pubKeyStr) {
        byte[] pubKeyBytes;
        if ((pubKeyStr = pubKeyStr.replaceAll("\\n", "")).startsWith("ssh") || pubKeyStr.startsWith("ecdsa")) {
            String[] algoAndKeyAndLocal = pubKeyStr.split(" ");
            pubKeyBytes = Base64.decode((String)algoAndKeyAndLocal[1]);
            this.identity = algoAndKeyAndLocal[2];
        } else {
            pubKeyBytes = Base64.decode((String)pubKeyStr);
        }
        OpenSSHPublicKeySpec pubKeySpec = new OpenSSHPublicKeySpec(pubKeyBytes);
        this.keyFormat = pubKeySpec.getFormat();
        this.keyType = pubKeySpec.getType();
        return OpenSSHPublicKeyUtil.parsePublicKey((byte[])pubKeyBytes);
    }

    public AsymmetricKeyParameter privKeyParse(String privKeyStr) {
        int rnd2;
        byte[] privKeyBytes;
        try {
            privKeyBytes = new PemReader((Reader)new StringReader(privKeyStr)).readPemObject().getContent();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), (Throwable)e);
        }
        OpenSSHPrivateKeySpec privKeySpec = new OpenSSHPrivateKeySpec(privKeyBytes);
        this.keyFormat = privKeySpec.getFormat();
        if (!this.keyFormat.equals("OpenSSH")) {
            return OpenSSHPrivateKeyUtil.parsePrivateKeyBlob((byte[])privKeyBytes);
        }
        byte[] AUTH_MAGIC = Strings.toByteArray((String)"openssh-key-v1\u0000");
        SSHKeyReader keyReader = new SSHKeyReader(AUTH_MAGIC, privKeyBytes);
        byte[] buffer = keyReader.readBytes();
        String cipherName = Strings.fromByteArray((byte[])buffer);
        if (!cipherName.equals("none")) {
            throw new SpecificationException("encrypted keys are not supported!");
        }
        String kdfName = Strings.fromByteArray((byte[])keyReader.readBytes());
        if (!kdfName.equals("none")) {
            throw new SpecificationException("KDFs are not supported!");
        }
        int kdfLength = keyReader.read32Bits();
        if (kdfLength != 0) {
            throw new SpecificationException("KDF's length should be 0!");
        }
        int keysNum = keyReader.read32Bits();
        if (keysNum != 1) {
            throw new SpecificationException("Number of keys should be 1!");
        }
        byte[] pubKeyBytes = keyReader.readBytes();
        OpenSSHPublicKeySpec pubKeySpec = new OpenSSHPublicKeySpec(pubKeyBytes);
        this.keyType = pubKeySpec.getType();
        byte[] privKeyWithCmt = keyReader.readBytes();
        SSHKeyReader privKeyReader = new SSHKeyReader(privKeyWithCmt);
        int rnd1 = privKeyReader.read32Bits();
        if (rnd1 != (rnd2 = privKeyReader.read32Bits())) {
            throw new SpecificationException("Two random values for checking are not same!");
        }
        String privKeyType = Strings.fromByteArray((byte[])privKeyReader.readBytes());
        if (!privKeyType.equals(this.keyType)) {
            throw new SpecificationException("Two key types in public/private keys are not same!");
        }
        Ed25519PrivateKeyParameters result = null;
        switch (privKeyType) {
            case "ssh-rsa": {
                BigInteger n = new BigInteger(1, privKeyReader.readBytes());
                BigInteger e = new BigInteger(1, privKeyReader.readBytes());
                BigInteger d = new BigInteger(1, privKeyReader.readBytes());
                BigInteger qInv = new BigInteger(1, privKeyReader.readBytes());
                BigInteger p = new BigInteger(1, privKeyReader.readBytes());
                BigInteger q = new BigInteger(1, privKeyReader.readBytes());
                BigInteger dP = d.remainder(p.subtract(BigInteger.ONE));
                BigInteger dQ = d.remainder(q.subtract(BigInteger.ONE));
                result = new RSAPrivateCrtKeyParameters(n, e, d, p, q, dP, dQ, qInv);
                break;
            }
            case "ssh-dss": {
                BigInteger p = new BigInteger(1, privKeyReader.readBytes());
                BigInteger q = new BigInteger(1, privKeyReader.readBytes());
                BigInteger g = new BigInteger(1, privKeyReader.readBytes());
                privKeyReader.readBytes();
                BigInteger x = new BigInteger(1, privKeyReader.readBytes());
                result = new DSAPrivateKeyParameters(x, new DSAParameters(p, q, g));
                break;
            }
            case "ecdsa-sha2-nistp256": {
                privKeyReader.readBytes();
                privKeyReader.readBytes();
                BigInteger d = new BigInteger(1, privKeyReader.readBytes());
                X9ECParameters x9Params = SECNamedCurves.getByName((String)"secp256r1");
                result = new ECPrivateKeyParameters(d, new ECDomainParameters(x9Params.getCurve(), x9Params.getG(), x9Params.getN(), x9Params.getH(), x9Params.getSeed()));
                break;
            }
            case "ssh-ed25519": {
                privKeyReader.readBytes();
                byte[] key = privKeyReader.readBytes();
                result = new Ed25519PrivateKeyParameters(key, 0);
                break;
            }
        }
        this.identity = Strings.fromByteArray((byte[])privKeyReader.readBytes());
        return result;
    }

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getIdentity() {
        return this.identity;
    }
}

