/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.classic;

import org.bouncycastle.crypto.digests.SHA256Digest;
import utils.security.Hasher;

public class SHA256Utils {
    public static final int SHA256DIGEST_LENGTH = 32;

    public static byte[] hash(byte[] data) {
        byte[] result = new byte[32];
        SHA256Digest sha256Digest = new SHA256Digest();
        sha256Digest.update(data, 0, data.length);
        sha256Digest.doFinal(result, 0);
        return result;
    }

    public static byte[] hash(byte[] data, int offset, int len) {
        byte[] result = new byte[32];
        SHA256Digest sha256Digest = new SHA256Digest();
        sha256Digest.update(data, offset, len);
        sha256Digest.doFinal(result, 0);
        return result;
    }

    public static Hasher beginHash() {
        return new SHA256Hasher();
    }

    private static class SHA256Hasher
    implements Hasher {
        private SHA256Digest sha256Digest = new SHA256Digest();

        private SHA256Hasher() {
        }

        public void update(byte[] bytes) {
            this.sha256Digest.update(bytes, 0, bytes.length);
        }

        public void update(byte[] bytes, int offset, int len) {
            this.sha256Digest.update(bytes, offset, len);
        }

        public byte[] complete() {
            byte[] result = new byte[32];
            this.sha256Digest.doFinal(result, 0);
            return result;
        }
    }
}

