/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.classic;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import utils.io.BytesOutputBuffer;
import utils.io.BytesUtils;
import utils.io.RuntimeIOException;
import utils.security.AlgorithmNotExistException;
import utils.security.DecryptionException;
import utils.security.EncryptionException;
import utils.security.SignatureException;
import utils.security.SpecificationException;

public class RSAUtils {
    private static final int KEYSIZEBITS = 2048;
    private static final int CERTAINTY = 100;
    private static final int MODULUS_LENGTH = 256;
    private static final int PRIVEXP_LENGTH = 256;
    private static final int P_LENGTH = 128;
    private static final int Q_LENGTH = 128;
    private static final int DP_LENGTH = 128;
    private static final int DQ_LENGTH = 128;
    private static final int QINV_LENGTH = 128;
    private static final BigInteger PUBEXP_0X03 = BigInteger.valueOf(3L);
    private static final BigInteger PUBEXP_0X010001 = BigInteger.valueOf(65537L);
    private static final BigInteger VERSION_2PRIMES = BigInteger.valueOf(0L);
    private static final AlgorithmIdentifier RSA_ALGORITHM_IDENTIFIER = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
    private static final int PLAINTEXT_BLOCKSIZE = 245;
    private static final int CIPHERTEXT_BLOCKSIZE = 256;

    public static AsymmetricCipherKeyPair generateKeyPair() {
        return RSAUtils.generateKeyPair(new SecureRandom());
    }

    public static AsymmetricCipherKeyPair generateKeyPair(SecureRandom random) {
        RSAKeyPairGenerator kpGen = new RSAKeyPairGenerator();
        kpGen.init((KeyGenerationParameters)new RSAKeyGenerationParameters(PUBEXP_0X010001, random, 2048, 100));
        return kpGen.generateKeyPair();
    }

    public static AsymmetricCipherKeyPair generateKeyPair_shortExp() {
        return RSAUtils.generateKeyPair_shortExp(new SecureRandom());
    }

    public static AsymmetricCipherKeyPair generateKeyPair_shortExp(SecureRandom random) {
        RSAKeyPairGenerator kpGen = new RSAKeyPairGenerator();
        kpGen.init((KeyGenerationParameters)new RSAKeyGenerationParameters(PUBEXP_0X03, random, 2048, 100));
        return kpGen.generateKeyPair();
    }

    public static byte[] retrievePublicKey(byte[] privateKey) {
        RSAPrivateCrtKeyParameters privKey = RSAUtils.bytes2PrivKey_RawKey(privateKey);
        BigInteger modulus = privKey.getModulus();
        BigInteger exponent = privKey.getPublicExponent();
        RSAKeyParameters pubKey = new RSAKeyParameters(false, modulus, exponent);
        return RSAUtils.pubKey2Bytes_RawKey(pubKey);
    }

    public static byte[] sign(byte[] data, byte[] privateKey) {
        RSAPrivateCrtKeyParameters privKey = RSAUtils.bytes2PrivKey_RawKey(privateKey);
        return RSAUtils.sign(data, (CipherParameters)privKey);
    }

    public static byte[] sign(byte[] data, CipherParameters params) {
        SHA256Digest digest = new SHA256Digest();
        RSADigestSigner signer = new RSADigestSigner((Digest)digest);
        signer.init(true, params);
        signer.update(data, 0, data.length);
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new SignatureException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] signature) {
        RSAKeyParameters pubKey = RSAUtils.bytes2PubKey_RawKey(publicKey);
        return RSAUtils.verify(data, 0, data.length, (CipherParameters)pubKey, signature);
    }

    public static boolean verify(byte[] data, int offset, int length, byte[] publicKey, byte[] signature) {
        RSAKeyParameters pubKey = RSAUtils.bytes2PubKey_RawKey(publicKey);
        return RSAUtils.verify(data, offset, length, (CipherParameters)pubKey, signature);
    }

    public static boolean verify(byte[] data, CipherParameters params, byte[] signature) {
        return RSAUtils.verify(data, 0, data.length, params, signature);
    }

    public static boolean verify(byte[] data, int offset, int length, CipherParameters params, byte[] signature) {
        SHA256Digest digest = new SHA256Digest();
        RSADigestSigner signer = new RSADigestSigner((Digest)digest);
        signer.init(false, params);
        signer.update(data, offset, length);
        return signer.verifySignature(signature);
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] publicKey) {
        RSAKeyParameters pubKey = RSAUtils.bytes2PubKey_RawKey(publicKey);
        return RSAUtils.encrypt(plainBytes, (CipherParameters)pubKey);
    }

    public static int encrypt(byte[] plainBytes, byte[] publicKey, OutputStream out) {
        RSAKeyParameters pubKey = RSAUtils.bytes2PubKey_RawKey(publicKey);
        return RSAUtils.encrypt(plainBytes, (CipherParameters)pubKey, out);
    }

    public static byte[] encrypt(byte[] plainBytes, int offset, int length, byte[] publicKey) {
        RSAKeyParameters pubKey = RSAUtils.bytes2PubKey_RawKey(publicKey);
        return RSAUtils.encrypt(plainBytes, offset, length, (CipherParameters)pubKey);
    }

    public static int encrypt(byte[] plainBytes, int offset, int length, byte[] publicKey, OutputStream out) {
        RSAKeyParameters pubKey = RSAUtils.bytes2PubKey_RawKey(publicKey);
        return RSAUtils.encrypt(plainBytes, offset, length, (CipherParameters)pubKey, out);
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] publicKey, SecureRandom random) {
        RSAKeyParameters pubKey = RSAUtils.bytes2PubKey_RawKey(publicKey);
        ParametersWithRandom params = new ParametersWithRandom((CipherParameters)pubKey, random);
        return RSAUtils.encrypt(plainBytes, (CipherParameters)params);
    }

    public static int calculateCipherBlockNum(int plaintextSize) {
        return plaintextSize % 245 == 0 ? plaintextSize / 245 : plaintextSize / 245 + 1;
    }

    public static int calculateCiphertextSize(int plaintextSize) {
        int blockNum = RSAUtils.calculateCipherBlockNum(plaintextSize);
        return blockNum * 256;
    }

    public static byte[] encrypt(byte[] plainBytes, CipherParameters params) {
        return RSAUtils.encrypt(plainBytes, 0, plainBytes.length, params);
    }

    public static byte[] encrypt(byte[] plainBytes, int offset, int length, CipherParameters params) {
        int plaintextSize = length;
        int blockNum = RSAUtils.calculateCipherBlockNum(plaintextSize);
        byte[] result = new byte[blockNum * 256];
        PKCS1Encoding encryptor = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        encryptor.init(true, params);
        try {
            byte[] buffer;
            int n = blockNum - 1;
            int inOffset = offset;
            int outOffset = 0;
            for (int i = 0; i < n; ++i) {
                buffer = encryptor.processBlock(plainBytes, inOffset, 245);
                System.arraycopy(buffer, 0, result, outOffset, 256);
                inOffset += 245;
                outOffset += 256;
            }
            buffer = encryptor.processBlock(plainBytes, inOffset, plaintextSize - inOffset);
            System.arraycopy(buffer, 0, result, outOffset, 256);
            inOffset += 245;
            outOffset += 256;
        }
        catch (InvalidCipherTextException e) {
            throw new EncryptionException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static int encrypt(byte[] plainBytes, CipherParameters params, OutputStream out) {
        return RSAUtils.encrypt(plainBytes, 0, plainBytes.length, params, out);
    }

    public static int encrypt(byte[] plainBytes, int offset, int length, CipherParameters params, OutputStream out) {
        int plaintextSize = length;
        int blockNum = RSAUtils.calculateCipherBlockNum(plaintextSize);
        int ciphertextSize = blockNum * 256;
        PKCS1Encoding encryptor = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        encryptor.init(true, params);
        try {
            byte[] cipherBlockBytes;
            int n = blockNum - 1;
            int inOffset = offset;
            for (int i = 0; i < n; ++i) {
                cipherBlockBytes = encryptor.processBlock(plainBytes, inOffset, 245);
                out.write(cipherBlockBytes, 0, 256);
                inOffset += 245;
            }
            cipherBlockBytes = encryptor.processBlock(plainBytes, inOffset, plaintextSize - inOffset);
            out.write(cipherBlockBytes, 0, 256);
            inOffset += 245;
            return ciphertextSize;
        }
        catch (InvalidCipherTextException e) {
            throw new EncryptionException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] decrypt(byte[] cipherBytes, byte[] privateKey) {
        RSAPrivateCrtKeyParameters privKey = RSAUtils.bytes2PrivKey_RawKey(privateKey);
        return RSAUtils.decrypt(cipherBytes, (CipherParameters)privKey);
    }

    public static int decrypt(byte[] cipherBytes, byte[] privateKey, OutputStream out) {
        RSAPrivateCrtKeyParameters privKey = RSAUtils.bytes2PrivKey_RawKey(privateKey);
        return RSAUtils.decrypt(cipherBytes, (CipherParameters)privKey, out);
    }

    public static byte[] decrypt(byte[] cipherBytes, int offset, int length, byte[] privateKey) {
        RSAPrivateCrtKeyParameters privKey = RSAUtils.bytes2PrivKey_RawKey(privateKey);
        return RSAUtils.decrypt(cipherBytes, offset, length, (CipherParameters)privKey);
    }

    public static int decrypt(byte[] cipherBytes, int offset, int length, byte[] privateKey, OutputStream out) {
        RSAPrivateCrtKeyParameters privKey = RSAUtils.bytes2PrivKey_RawKey(privateKey);
        return RSAUtils.decrypt(cipherBytes, offset, length, (CipherParameters)privKey, out);
    }

    public static byte[] decrypt(byte[] cipherBytes, CipherParameters params) {
        return RSAUtils.decrypt(cipherBytes, 0, cipherBytes.length, params);
    }

    public static byte[] decrypt(byte[] cipherBytes, int offset, int length, CipherParameters params) {
        if (length % 256 != 0) {
            throw new DecryptionException("ciphertext's length is wrong! Must be an integer multiple of CIPHERTEXT_BLOCKSIZE[256]!");
        }
        int blockNum = length / 256;
        int inOffset = offset;
        BytesOutputBuffer outBuffer = new BytesOutputBuffer();
        PKCS1Encoding decryptor = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        decryptor.init(false, params);
        try {
            for (int i = 0; i < blockNum; ++i) {
                byte[] buffer = decryptor.processBlock(cipherBytes, inOffset, 256);
                inOffset += 256;
                outBuffer.write(buffer);
            }
            return outBuffer.toBytes();
        }
        catch (InvalidCipherTextException e) {
            throw new EncryptionException(e.getMessage(), (Throwable)e);
        }
    }

    public static int decrypt(byte[] cipherBytes, CipherParameters params, OutputStream out) {
        return RSAUtils.decrypt(cipherBytes, 0, cipherBytes.length, params, out);
    }

    public static int decrypt(byte[] cipherBytes, int offset, int length, CipherParameters params, OutputStream out) {
        if (length % 256 != 0) {
            throw new EncryptionException("ciphertext's length is wrong! Must be an integer multiple of CIPHERTEXT_BLOCKSIZE[256]!");
        }
        int blockNum = length / 256;
        int size = 0;
        int inOffset = offset;
        PKCS1Encoding decryptor = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        decryptor.init(false, params);
        try {
            for (int i = 0; i < blockNum; ++i) {
                byte[] buffer = decryptor.processBlock(cipherBytes, inOffset, 256);
                out.write(buffer);
                inOffset += 256;
                size += buffer.length;
            }
            return size;
        }
        catch (InvalidCipherTextException e) {
            throw new EncryptionException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] pubKey2Bytes_PKCS1(RSAKeyParameters pubKey) {
        byte[] result;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(pubKey.getModulus()));
        v.add((ASN1Encodable)new ASN1Integer(pubKey.getExponent()));
        DERSequence pubKeySequence = new DERSequence(v);
        try {
            result = pubKeySequence.getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static byte[] pubKey2Bytes_PKCS8(RSAKeyParameters pubKey) {
        BigInteger modulus = pubKey.getModulus();
        BigInteger exponent = pubKey.getExponent();
        return KeyUtil.getEncodedSubjectPublicKeyInfo((AlgorithmIdentifier)RSA_ALGORITHM_IDENTIFIER, (ASN1Encodable)new RSAPublicKey(modulus, exponent));
    }

    public static byte[] pubKey2Bytes_RawKey(RSAKeyParameters pubKey) {
        BigInteger modulus = pubKey.getModulus();
        BigInteger exponent = pubKey.getExponent();
        byte[] exponentBytes = exponent.toByteArray();
        byte[] modulusBytes = RSAUtils.bigInteger2Bytes(modulus, 256);
        return BytesUtils.concat((byte[][])new byte[][]{modulusBytes, exponentBytes});
    }

    public static RSAKeyParameters bytes2PubKey_PKCS1(byte[] pubKeyBytes) {
        ASN1Sequence pubKeySequence = ASN1Sequence.getInstance((Object)pubKeyBytes);
        BigInteger modulus = ASN1Integer.getInstance((Object)pubKeySequence.getObjectAt(0)).getValue();
        BigInteger exponent = ASN1Integer.getInstance((Object)pubKeySequence.getObjectAt(1)).getValue();
        return new RSAKeyParameters(false, modulus, exponent);
    }

    public static RSAKeyParameters bytes2PubKey_PKCS8(byte[] pubKeyBytes) {
        java.security.interfaces.RSAPublicKey publicKey;
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubKeyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SpecificationException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmNotExistException(e.getMessage(), (Throwable)e);
        }
        BigInteger exponent = publicKey.getPublicExponent();
        BigInteger modulus = publicKey.getModulus();
        return new RSAKeyParameters(false, modulus, exponent);
    }

    public static RSAKeyParameters bytes2PubKey_RawKey(byte[] pubKeyBytes) {
        byte[] modulusBytes = new byte[256];
        byte[] exponentBytes = new byte[pubKeyBytes.length - 256];
        System.arraycopy(pubKeyBytes, 0, modulusBytes, 0, 256);
        System.arraycopy(pubKeyBytes, 256, exponentBytes, 0, exponentBytes.length);
        BigInteger modulus = new BigInteger(1, modulusBytes);
        BigInteger exponent = new BigInteger(1, exponentBytes);
        return new RSAKeyParameters(false, modulus, exponent);
    }

    public static byte[] privKey2Bytes_PKCS1(RSAPrivateCrtKeyParameters privKey) {
        byte[] result;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(VERSION_2PRIMES));
        v.add((ASN1Encodable)new ASN1Integer(privKey.getModulus()));
        v.add((ASN1Encodable)new ASN1Integer(privKey.getPublicExponent()));
        v.add((ASN1Encodable)new ASN1Integer(privKey.getExponent()));
        v.add((ASN1Encodable)new ASN1Integer(privKey.getP()));
        v.add((ASN1Encodable)new ASN1Integer(privKey.getQ()));
        v.add((ASN1Encodable)new ASN1Integer(privKey.getDP()));
        v.add((ASN1Encodable)new ASN1Integer(privKey.getDQ()));
        v.add((ASN1Encodable)new ASN1Integer(privKey.getQInv()));
        DERSequence privKeySequence = new DERSequence(v);
        try {
            result = privKeySequence.getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static byte[] privKey2Bytes_PKCS8(RSAPrivateCrtKeyParameters privKey) {
        BigInteger modulus = privKey.getModulus();
        BigInteger pubExp = privKey.getPublicExponent();
        BigInteger privExp = privKey.getExponent();
        BigInteger p = privKey.getP();
        BigInteger q = privKey.getQ();
        BigInteger dP = privKey.getDP();
        BigInteger dQ = privKey.getDQ();
        BigInteger qInv = privKey.getQInv();
        return KeyUtil.getEncodedPrivateKeyInfo((AlgorithmIdentifier)RSA_ALGORITHM_IDENTIFIER, (ASN1Encodable)new RSAPrivateKey(modulus, pubExp, privExp, p, q, dP, dQ, qInv));
    }

    public static byte[] privKey2Bytes_RawKey(RSAPrivateCrtKeyParameters privKey) {
        BigInteger modulus = privKey.getModulus();
        BigInteger pubExp = privKey.getPublicExponent();
        BigInteger privExp = privKey.getExponent();
        BigInteger p = privKey.getP();
        BigInteger q = privKey.getQ();
        BigInteger dP = privKey.getDP();
        BigInteger dQ = privKey.getDQ();
        BigInteger qInv = privKey.getQInv();
        byte[] modulusBytes = RSAUtils.bigInteger2Bytes(modulus, 256);
        byte[] pubExpBytes = pubExp.toByteArray();
        byte[] privExpBytes = RSAUtils.bigInteger2Bytes(privExp, 256);
        byte[] pBytes = RSAUtils.bigInteger2Bytes(p, 128);
        byte[] qBytes = RSAUtils.bigInteger2Bytes(q, 128);
        byte[] dPBytes = RSAUtils.bigInteger2Bytes(dP, 128);
        byte[] dQBytes = RSAUtils.bigInteger2Bytes(dQ, 128);
        byte[] qInvBytes = RSAUtils.bigInteger2Bytes(qInv, 128);
        return BytesUtils.concat((byte[][])new byte[][]{modulusBytes, pubExpBytes, privExpBytes, pBytes, qBytes, dPBytes, dQBytes, qInvBytes});
    }

    public static RSAPrivateCrtKeyParameters bytes2PrivKey_PKCS1(byte[] privKeyBytes) {
        ASN1Sequence priKeySequence = ASN1Sequence.getInstance((Object)privKeyBytes);
        BigInteger modulus = ASN1Integer.getInstance((Object)priKeySequence.getObjectAt(1)).getValue();
        BigInteger pubExp = ASN1Integer.getInstance((Object)priKeySequence.getObjectAt(2)).getValue();
        BigInteger privExp = ASN1Integer.getInstance((Object)priKeySequence.getObjectAt(3)).getValue();
        BigInteger p = ASN1Integer.getInstance((Object)priKeySequence.getObjectAt(4)).getValue();
        BigInteger q = ASN1Integer.getInstance((Object)priKeySequence.getObjectAt(5)).getValue();
        BigInteger dP = ASN1Integer.getInstance((Object)priKeySequence.getObjectAt(6)).getValue();
        BigInteger dQ = ASN1Integer.getInstance((Object)priKeySequence.getObjectAt(7)).getValue();
        BigInteger qInv = ASN1Integer.getInstance((Object)priKeySequence.getObjectAt(8)).getValue();
        return new RSAPrivateCrtKeyParameters(modulus, pubExp, privExp, p, q, dP, dQ, qInv);
    }

    public static RSAPrivateCrtKeyParameters bytes2PrivKey_PKCS8(byte[] privKeyBytes) {
        RSAPrivateCrtKey privateKey;
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privKeyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = (RSAPrivateCrtKey)keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SpecificationException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmNotExistException(e.getMessage(), (Throwable)e);
        }
        BigInteger modulus = privateKey.getModulus();
        BigInteger pubExp = privateKey.getPublicExponent();
        BigInteger privExp = privateKey.getPrivateExponent();
        BigInteger p = privateKey.getPrimeP();
        BigInteger q = privateKey.getPrimeQ();
        BigInteger dP = privateKey.getPrimeExponentP();
        BigInteger dQ = privateKey.getPrimeExponentQ();
        BigInteger qInv = privateKey.getCrtCoefficient();
        return new RSAPrivateCrtKeyParameters(modulus, pubExp, privExp, p, q, dP, dQ, qInv);
    }

    public static RSAPrivateCrtKeyParameters bytes2PrivKey_RawKey(byte[] privKeyBytes) {
        byte[] modulusBytes = new byte[256];
        byte[] pubExpBytes = new byte[privKeyBytes.length - 256 - 256 - 128 - 128 - 128 - 128 - 128];
        byte[] privExpBytes = new byte[256];
        byte[] pBytes = new byte[128];
        byte[] qBytes = new byte[128];
        byte[] dPBytes = new byte[128];
        byte[] dQBytes = new byte[128];
        byte[] qInvBytes = new byte[128];
        System.arraycopy(privKeyBytes, 0, modulusBytes, 0, 256);
        System.arraycopy(privKeyBytes, 256, pubExpBytes, 0, pubExpBytes.length);
        System.arraycopy(privKeyBytes, 256 + pubExpBytes.length, privExpBytes, 0, 256);
        System.arraycopy(privKeyBytes, 256 + pubExpBytes.length + 256, pBytes, 0, 128);
        System.arraycopy(privKeyBytes, 256 + pubExpBytes.length + 256 + 128, qBytes, 0, 128);
        System.arraycopy(privKeyBytes, 256 + pubExpBytes.length + 256 + 128 + 128, dPBytes, 0, 128);
        System.arraycopy(privKeyBytes, 256 + pubExpBytes.length + 256 + 128 + 128 + 128, dQBytes, 0, 128);
        System.arraycopy(privKeyBytes, 256 + pubExpBytes.length + 256 + 128 + 128 + 128 + 128, qInvBytes, 0, 128);
        BigInteger modulus = new BigInteger(1, modulusBytes);
        BigInteger pubExp = new BigInteger(1, pubExpBytes);
        BigInteger privExp = new BigInteger(1, privExpBytes);
        BigInteger p = new BigInteger(1, pBytes);
        BigInteger q = new BigInteger(1, qBytes);
        BigInteger dP = new BigInteger(1, dPBytes);
        BigInteger dQ = new BigInteger(1, dQBytes);
        BigInteger qInv = new BigInteger(1, qInvBytes);
        return new RSAPrivateCrtKeyParameters(modulus, pubExp, privExp, p, q, dP, dQ, qInv);
    }

    private static byte[] bigInteger2Bytes(BigInteger src, int length) {
        byte[] result = new byte[length];
        byte[] srcBytes = src.toByteArray();
        int srcLength = srcBytes.length;
        if (srcLength > length) {
            System.arraycopy(srcBytes, srcLength - length, result, 0, length);
        } else {
            System.arraycopy(srcBytes, 0, result, length - srcLength, srcLength);
        }
        return result;
    }
}

