/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.classic;

import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import utils.security.Hasher;

public class RIPEMD160Utils {
    public static final int RIPEMD160DIGEST_LENGTH = 20;

    public static byte[] hash(byte[] data) {
        byte[] result = new byte[20];
        RIPEMD160Digest ripemd160Digest = new RIPEMD160Digest();
        ripemd160Digest.update(data, 0, data.length);
        ripemd160Digest.doFinal(result, 0);
        return result;
    }

    public static byte[] hash(byte[] data, int offset, int len) {
        byte[] result = new byte[20];
        RIPEMD160Digest ripemd160Digest = new RIPEMD160Digest();
        ripemd160Digest.update(data, offset, len);
        ripemd160Digest.doFinal(result, 0);
        return result;
    }

    public static Hasher beginHash() {
        return new RipeMD160Hasher();
    }

    private static class RipeMD160Hasher
    implements Hasher {
        private RIPEMD160Digest digest = new RIPEMD160Digest();

        private RipeMD160Hasher() {
        }

        public void update(byte[] bytes) {
            this.digest.update(bytes, 0, bytes.length);
        }

        public void update(byte[] bytes, int offset, int len) {
            this.digest.update(bytes, offset, len);
        }

        public byte[] complete() {
            byte[] result = new byte[20];
            this.digest.doFinal(result, 0);
            return result;
        }
    }
}

