/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.classic;

import org.bouncycastle.crypto.InvalidCipherTextException;

public class PKCS7PaddingUtils {
    public static int addPadding(byte[] target, int paddingOffset, byte paddingCode) {
        for (int i = 0; i < paddingCode; ++i) {
            target[paddingOffset + i] = paddingCode;
        }
        return paddingCode;
    }

    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count = in[in.length - 1] & 0xFF;
        byte countAsbyte = (byte)count;
        boolean failed = count > in.length | count == 0;
        for (int i = 0; i < in.length; ++i) {
            failed |= in.length - i <= count & in[i] != countAsbyte;
        }
        if (failed) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return count;
    }
}

