/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.classic;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.prng.FixedSecureRandom;
import org.bouncycastle.crypto.signers.Ed25519Signer;

public class ED25519Utils {
    public static final int SEED_MIN_LENGTH = 32;

    public static void checkKeyGenSeed(byte[] seed) {
        if (seed.length < 32) {
            throw new IllegalArgumentException("The length of the seed is less than the min value 32!");
        }
    }

    public static AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom random = new SecureRandom();
        return ED25519Utils.generateKeyPair(random);
    }

    public static AsymmetricCipherKeyPair generateKeyPair(byte[] seed) {
        ED25519Utils.checkKeyGenSeed(seed);
        return ED25519Utils.generateKeyPair((SecureRandom)new FixedSecureRandom(seed));
    }

    public static byte[][] generateKeyPairBytes(byte[] seed) {
        if (seed.length < 32) {
            throw new IllegalArgumentException("The length of the seed is less than the min value 32!");
        }
        return ED25519Utils.generateKeyPairBytes((SecureRandom)new FixedSecureRandom(seed));
    }

    public static AsymmetricCipherKeyPair generateKeyPair(SecureRandom random) {
        Ed25519KeyPairGenerator keyPairGenerator = new Ed25519KeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters(random));
        return keyPairGenerator.generateKeyPair();
    }

    public static byte[][] generateKeyPairBytes(SecureRandom random) {
        AsymmetricCipherKeyPair keyPair = ED25519Utils.generateKeyPair(random);
        Ed25519PrivateKeyParameters privKeyParams = (Ed25519PrivateKeyParameters)keyPair.getPrivate();
        Ed25519PublicKeyParameters pubKeyParams = (Ed25519PublicKeyParameters)keyPair.getPublic();
        byte[] privKeyBytes = privKeyParams.getEncoded();
        byte[] pubKeyBytes = pubKeyParams.getEncoded();
        return new byte[][]{pubKeyBytes, privKeyBytes};
    }

    public static byte[] retrievePublicKey(byte[] privateKey) {
        Ed25519PrivateKeyParameters privKeyParams = new Ed25519PrivateKeyParameters(privateKey, 0);
        return privKeyParams.generatePublicKey().getEncoded();
    }

    public static byte[] sign(byte[] data, byte[] privateKey) {
        Ed25519PrivateKeyParameters privKeyParams = new Ed25519PrivateKeyParameters(privateKey, 0);
        return ED25519Utils.sign(data, (CipherParameters)privKeyParams);
    }

    public static byte[] sign(byte[] data, CipherParameters params) {
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, params);
        signer.update(data, 0, data.length);
        return signer.generateSignature();
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] signature) {
        Ed25519PublicKeyParameters pubKeyParams = new Ed25519PublicKeyParameters(publicKey, 0);
        return ED25519Utils.verify(data, 0, data.length, (CipherParameters)pubKeyParams, signature);
    }

    public static boolean verify(byte[] data, int offset, int length, byte[] publicKey, byte[] signature) {
        Ed25519PublicKeyParameters pubKeyParams = new Ed25519PublicKeyParameters(publicKey, 0);
        return ED25519Utils.verify(data, offset, length, (CipherParameters)pubKeyParams, signature);
    }

    public static boolean verify(byte[] data, CipherParameters params, byte[] signature) {
        return ED25519Utils.verify(data, 0, data.length, params, signature);
    }

    public static boolean verify(byte[] data, int offset, int length, CipherParameters params, byte[] signature) {
        Ed25519Signer verifier = new Ed25519Signer();
        verifier.init(false, params);
        verifier.update(data, offset, length);
        return verifier.verifySignature(signature);
    }
}

