/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.classic;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import utils.crypto.classic.SHA256Utils;

public class ECDSAUtils {
    public static final int R_SIZE = 32;
    public static final int S_SIZE = 32;
    private static final ECNamedCurveParameterSpec PARAMS = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
    private static final ECCurve CURVE = PARAMS.getCurve();
    public static final ECDomainParameters DOMAIN_PARAMS = new ECDomainParameters(CURVE, PARAMS.getG(), PARAMS.getN(), PARAMS.getH());

    public static AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom random = new SecureRandom();
        return ECDSAUtils.generateKeyPair(random);
    }

    public static AsymmetricCipherKeyPair generateKeyPair(SecureRandom random) {
        ECKeyGenerationParameters keyGenerationParams = new ECKeyGenerationParameters(DOMAIN_PARAMS, random);
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)keyGenerationParams);
        return keyPairGenerator.generateKeyPair();
    }

    public static byte[] retrievePublicKey(byte[] privateKey) {
        ECPoint publicKeyPoint = DOMAIN_PARAMS.getG().multiply(new BigInteger(1, privateKey)).normalize();
        return publicKeyPoint.getEncoded(false);
    }

    public static byte[] sign(byte[] data, byte[] privateKey) {
        return ECDSAUtils.sign(data, 0, data.length, privateKey);
    }

    public static byte[] sign(byte[] data, int offset, int length, byte[] privateKey) {
        SecureRandom random = new SecureRandom();
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(new BigInteger(1, privateKey), DOMAIN_PARAMS);
        ParametersWithRandom params = new ParametersWithRandom((CipherParameters)privKey, random);
        return ECDSAUtils.sign(data, offset, length, (CipherParameters)params);
    }

    public static byte[] sign(byte[] data, byte[] privateKey, SecureRandom random) {
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(new BigInteger(1, privateKey), DOMAIN_PARAMS);
        ParametersWithRandom params = new ParametersWithRandom((CipherParameters)privKey, random);
        return ECDSAUtils.sign(data, 0, data.length, (CipherParameters)params);
    }

    public static byte[] sign(byte[] data, CipherParameters params) {
        return ECDSAUtils.sign(data, 0, data.length, params);
    }

    public static byte[] sign(byte[] data, int offset, int length, CipherParameters params) {
        byte[] hashedMsg = SHA256Utils.hash(data, offset, length);
        return ECDSAUtils.sign(params, hashedMsg);
    }

    public static byte[] sign(CipherParameters params, byte[] hashedMsg) {
        ECDSASigner signer = new ECDSASigner();
        signer.init(true, params);
        BigInteger[] signature = signer.generateSignature(hashedMsg);
        byte[] rBytes = ECDSAUtils.trimBigIntegerTo32Bytes(signature[0]);
        byte[] sBytes = ECDSAUtils.trimBigIntegerTo32Bytes(signature[1]);
        byte[] result = new byte[64];
        System.arraycopy(rBytes, 0, result, 0, 32);
        System.arraycopy(sBytes, 0, result, 32, 32);
        return result;
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] signature) {
        return ECDSAUtils.verify(data, 0, data.length, publicKey, signature);
    }

    public static boolean verify(byte[] data, int offset, int length, byte[] publicKey, byte[] signature) {
        ECPoint pubKeyPoint = ECDSAUtils.resolvePubKeyBytes(publicKey);
        ECPublicKeyParameters pubKey = new ECPublicKeyParameters(pubKeyPoint, DOMAIN_PARAMS);
        return ECDSAUtils.verify(data, offset, length, (CipherParameters)pubKey, signature);
    }

    public static boolean verify(byte[] data, CipherParameters params, byte[] signature) {
        return ECDSAUtils.verify(data, 0, data.length, params, signature);
    }

    public static boolean verify(byte[] data, int offset, int length, CipherParameters params, byte[] signature) {
        byte[] hashedMsg = SHA256Utils.hash(data, offset, length);
        return ECDSAUtils.verify(params, signature, hashedMsg);
    }

    public static boolean verify(CipherParameters params, byte[] signature, byte[] hashedMsg) {
        byte[] rBytes = new byte[32];
        byte[] sBytes = new byte[32];
        System.arraycopy(signature, 0, rBytes, 0, 32);
        System.arraycopy(signature, 32, sBytes, 0, 32);
        BigInteger r = new BigInteger(1, rBytes);
        BigInteger s = new BigInteger(1, sBytes);
        ECDSASigner verifier = new ECDSASigner();
        verifier.init(false, params);
        return verifier.verifySignature(hashedMsg, r, s);
    }

    public static byte[] trimBigIntegerTo32Bytes(BigInteger b) {
        byte[] result;
        byte[] tmp = b.toByteArray();
        if (tmp.length > (result = new byte[32]).length) {
            System.arraycopy(tmp, tmp.length - result.length, result, 0, result.length);
        } else {
            System.arraycopy(tmp, 0, result, result.length - tmp.length, tmp.length);
        }
        return result;
    }

    private static ECPoint resolvePubKeyBytes(byte[] publicKey) {
        return CURVE.decodePoint(publicKey);
    }

    public static ECCurve getCurve() {
        return CURVE;
    }

    public static ECDomainParameters getDomainParams() {
        return DOMAIN_PARAMS;
    }

    public static byte[] privKey2Bytes_RawKey(ECPrivateKeyParameters privKey) {
        byte[] privKeyBytes = ECDSAUtils.trimBigIntegerTo32Bytes(privKey.getD());
        return privKeyBytes;
    }

    public static byte[] pubKey2Bytes_RawKey(ECPublicKeyParameters pubKey) {
        byte[] pubKeyBytes = pubKey.getQ().getEncoded(false);
        return pubKeyBytes;
    }
}

