/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.classic;

import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import utils.crypto.classic.PKCS7PaddingUtils;
import utils.crypto.classic.SHA256Utils;
import utils.security.DecryptionException;
import utils.security.EncryptionException;

public class AESUtils {
    public static final int KEY_SIZE = 16;
    public static final int BLOCK_SIZE = 16;
    public static final int IV_SIZE = 16;

    public static byte[] generateKey() {
        CipherKeyGenerator keyGenerator = new CipherKeyGenerator();
        keyGenerator.init(new KeyGenerationParameters(new SecureRandom(), 128));
        return keyGenerator.generateKey();
    }

    public static byte[] generateKey(byte[] seed) {
        byte[] hash = SHA256Utils.hash(seed);
        return Arrays.copyOf(hash, 16);
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] secretKey) {
        return AESUtils.encrypt(plainBytes, 0, plainBytes.length, secretKey);
    }

    public static byte[] encrypt(byte[] plainBytes, int offset, int length, byte[] secretKey) {
        byte[] iv = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        return AESUtils.encrypt(plainBytes, offset, length, secretKey, iv);
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] secretKey, byte[] iv) {
        return AESUtils.encrypt(plainBytes, 0, plainBytes.length, secretKey, iv);
    }

    public static byte[] encrypt(byte[] plainBytes, int offset, int length, byte[] secretKey, byte[] iv) {
        if (plainBytes == null) {
            throw new EncryptionException("plaintext is null!");
        }
        if (secretKey.length != 16) {
            throw new EncryptionException("secretKey's length is wrong!");
        }
        if (iv.length != 16) {
            throw new EncryptionException("iv's length is wrong!");
        }
        byte padding = AESUtils.getAESPadding(length);
        int lengthWithPadding = length + padding;
        byte[] input = new byte[lengthWithPadding];
        System.arraycopy(plainBytes, offset, input, 0, length);
        PKCS7PaddingUtils.addPadding(input, length, padding);
        byte[] output = new byte[16 + lengthWithPadding];
        System.arraycopy(iv, 0, output, 0, 16);
        CBCBlockCipher encryptor = new CBCBlockCipher((BlockCipher)new AESEngine());
        encryptor.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(secretKey), iv));
        int blockCount = lengthWithPadding / 16;
        for (int i = 0; i < blockCount; ++i) {
            int blockOffset = i * 16;
            encryptor.processBlock(input, blockOffset, output, 16 + blockOffset);
        }
        return output;
    }

    public static byte getAESPadding(int dataLength) {
        return (byte)(16 - dataLength % 16);
    }

    public static int getCiphertextSizeWithPadding(int plaintextSize) {
        int paddingSize = 16 - plaintextSize % 16;
        return plaintextSize + paddingSize;
    }

    public static int getCiphertextSizeWithPadding_IV(int plaintextSize) {
        int paddingSize = 16 - plaintextSize % 16;
        return 16 + plaintextSize + paddingSize;
    }

    public static byte[] decrypt(byte[] cipherBytes, byte[] secretKey) {
        return AESUtils.decrypt(cipherBytes, 0, cipherBytes.length, secretKey);
    }

    public static byte[] decrypt(byte[] cipherBytes, int offset, int length, byte[] secretKey) {
        if (cipherBytes == null) {
            throw new IllegalArgumentException("ciphertext is null!");
        }
        if (length % 16 != 0) {
            throw new DecryptionException("ciphertext's length is wrong! Must be an integer multiple of BLOCK_SIZE[16]!");
        }
        if (secretKey.length != 16) {
            throw new DecryptionException("secretKey's length is wrong!");
        }
        byte[] iv = new byte[16];
        System.arraycopy(cipherBytes, offset, iv, 0, 16);
        CBCBlockCipher decryptor = new CBCBlockCipher((BlockCipher)new AESEngine());
        decryptor.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(secretKey), iv));
        byte[] outputWithPadding = new byte[length - 16];
        int blockcount = length / 16;
        for (int i = 1; i < blockcount; ++i) {
            decryptor.processBlock(cipherBytes, offset + i * 16, outputWithPadding, (i - 1) * 16);
        }
        int p = outputWithPadding[outputWithPadding.length - 1];
        if (p > 16 || p < 1) {
            throw new DecryptionException("There no exists such padding!");
        }
        for (int i = 0; i < p; ++i) {
            if (outputWithPadding[outputWithPadding.length - i - 1] == p) continue;
            throw new DecryptionException("Padding is invalid!");
        }
        byte[] output = new byte[outputWithPadding.length - p];
        System.arraycopy(outputWithPadding, 0, output, 0, output.length);
        return output;
    }
}

