/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.processors.impl.font;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.svg.css.impl.SvgStyleResolver;
import com.itextpdf.svg.processors.impl.SvgProcessorContext;
import com.itextpdf.svg.processors.impl.font.FontFace;
import java.util.Collection;
import org.slf4j.LoggerFactory;

public class SvgFontProcessor {
    private SvgProcessorContext context;

    public SvgFontProcessor(SvgProcessorContext context) {
        this.context = context;
    }

    public void addFontFaceFonts(ICssResolver cssResolver) {
        if (cssResolver instanceof SvgStyleResolver) {
            for (CssFontFaceRule fontFace : ((SvgStyleResolver)cssResolver).getFonts()) {
                boolean findSupportedSrc = false;
                FontFace ff = FontFace.create(fontFace.getProperties());
                if (ff != null) {
                    for (FontFace.FontFaceSrc src : ff.getSources()) {
                        if (!this.createFont(ff.getFontFamily(), src)) continue;
                        findSupportedSrc = true;
                        break;
                    }
                }
                if (findSupportedSrc) continue;
                LoggerFactory.getLogger(SvgFontProcessor.class).error(MessageFormatUtil.format((String)"Unable to retrieve font:\n {0}", (Object[])new Object[]{fontFace}));
            }
        }
    }

    private boolean createFont(String fontFamily, FontFace.FontFaceSrc src) {
        if (!this.supportedFontFormat(src.format)) {
            return false;
        }
        if (src.isLocal) {
            Collection fonts = this.context.getFontProvider().getFontSet().get(src.src);
            if (fonts.size() > 0) {
                for (FontInfo fi : fonts) {
                    this.context.addTemporaryFont(fi, fontFamily);
                }
                return true;
            }
            return false;
        }
        try {
            byte[] bytes = this.context.getResourceResolver().retrieveBytesFromResource(src.src);
            if (bytes != null) {
                FontProgram fp = FontProgramFactory.createFont((byte[])bytes, (boolean)false);
                this.context.addTemporaryFont(fp, "Identity-H", fontFamily);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean supportedFontFormat(FontFace.FontFormat format) {
        switch (format) {
            case None: 
            case TrueType: 
            case OpenType: 
            case WOFF: 
            case WOFF2: {
                return true;
            }
        }
        return false;
    }
}

