/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.resolver.resource;

import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import java.util.LinkedHashMap;
import java.util.Map;

class SimpleImageCache {
    private Map<String, PdfImageXObject> cache = new LinkedHashMap<String, PdfImageXObject>();
    private Map<String, Integer> imagesFrequency = new LinkedHashMap<String, Integer>();
    private int capacity;

    SimpleImageCache() {
        this.capacity = 100;
    }

    SimpleImageCache(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity");
        }
        this.capacity = capacity;
    }

    void putImage(String src, PdfImageXObject imageXObject) {
        if (this.cache.containsKey(src)) {
            return;
        }
        this.ensureCapacity();
        this.cache.put(src, imageXObject);
    }

    PdfImageXObject getImage(String src) {
        Integer frequency = this.imagesFrequency.get(src);
        if (frequency != null) {
            this.imagesFrequency.put(src, frequency + 1);
        } else {
            this.imagesFrequency.put(src, 1);
        }
        return this.cache.get(src);
    }

    int size() {
        return this.cache.size();
    }

    void reset() {
        this.cache.clear();
        this.imagesFrequency.clear();
    }

    private void ensureCapacity() {
        if (this.cache.size() >= this.capacity) {
            String mostUnpopularImg = null;
            int minFrequency = Integer.MAX_VALUE;
            for (String imgSrc : this.cache.keySet()) {
                Integer imgFrequency = this.imagesFrequency.get(imgSrc);
                if (imgFrequency != null && imgFrequency >= minFrequency) continue;
                mostUnpopularImg = imgSrc;
                if (imgFrequency == null) break;
                minFrequency = imgFrequency;
            }
            this.cache.remove(mostUnpopularImg);
        }
    }
}

