/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.AlignmentPropertyValue;
import com.itextpdf.layout.properties.FlexDirectionPropertyValue;
import com.itextpdf.layout.properties.FlexWrapPropertyValue;
import com.itextpdf.layout.properties.InlineVerticalAlignmentType;
import com.itextpdf.layout.properties.JustifyContent;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.FlexContainerRenderer;
import com.itextpdf.layout.renderer.FlexItemInfo;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FlexUtil {
    private static final float EPSILON = 1.0E-4f;
    private static final float FLEX_GROW_INITIAL_VALUE = 0.0f;
    private static final float FLEX_SHRINK_INITIAL_VALUE = 1.0f;
    private static Logger logger = LoggerFactory.getLogger(FlexUtil.class);

    private FlexUtil() {
    }

    public static List<List<FlexItemInfo>> calculateChildrenRectangles(Rectangle flexContainerBBox, FlexContainerRenderer flexContainerRenderer) {
        Rectangle layoutBox = flexContainerBBox.clone();
        flexContainerRenderer.applyMarginsBordersPaddings(layoutBox, false);
        float mainSize = FlexUtil.getMainSize(flexContainerRenderer, layoutBox);
        Float[] crossSizes = FlexUtil.getCrossSizes(flexContainerRenderer, layoutBox);
        Float crossSize = crossSizes[0];
        Float minCrossSize = crossSizes[1];
        Float maxCrossSize = crossSizes[2];
        float layoutBoxCrossSize = FlexUtil.isColumnDirection(flexContainerRenderer) ? layoutBox.getWidth() : layoutBox.getHeight();
        layoutBoxCrossSize = crossSize == null ? layoutBoxCrossSize : Math.min(crossSize.floatValue(), layoutBoxCrossSize);
        List<FlexItemCalculationInfo> flexItemCalculationInfos = FlexUtil.createFlexItemCalculationInfos(flexContainerRenderer, mainSize, layoutBoxCrossSize);
        FlexUtil.determineFlexBasisAndHypotheticalMainSizeForFlexItems(flexItemCalculationInfos, layoutBoxCrossSize, FlexUtil.isColumnDirection(flexContainerRenderer));
        boolean isSingleLine = !flexContainerRenderer.hasProperty(128) || FlexWrapPropertyValue.NOWRAP == flexContainerRenderer.getProperty(128);
        List<List<FlexItemCalculationInfo>> lines = FlexUtil.collectFlexItemsIntoFlexLines(flexItemCalculationInfos, mainSize, isSingleLine);
        float maxHypotheticalMainSize = 0.0f;
        for (List<FlexItemCalculationInfo> line : lines) {
            float hypotheticalMainSizesSum = 0.0f;
            for (FlexItemCalculationInfo info : line) {
                hypotheticalMainSizesSum += info.getOuterMainSize(info.hypotheticalMainSize);
            }
            maxHypotheticalMainSize = Math.max(maxHypotheticalMainSize, hypotheticalMainSizesSum);
        }
        float containerMainSize = FlexUtil.getMainSize(flexContainerRenderer, new Rectangle(FlexUtil.isColumnDirection(flexContainerRenderer) ? 0.0f : maxHypotheticalMainSize, FlexUtil.isColumnDirection(flexContainerRenderer) ? maxHypotheticalMainSize : 0.0f));
        if (FlexUtil.isColumnDirection(flexContainerRenderer)) {
            FlexUtil.resolveFlexibleLengths(lines, containerMainSize);
        } else {
            FlexUtil.resolveFlexibleLengths(lines, mainSize);
        }
        FlexUtil.determineHypotheticalCrossSizeForFlexItems(lines, FlexUtil.isColumnDirection(flexContainerRenderer), layoutBoxCrossSize);
        List<Float> lineCrossSizes = FlexUtil.calculateCrossSizeOfEachFlexLine(lines, minCrossSize, crossSize, maxCrossSize);
        float flexLinesCrossSizesSum = 0.0f;
        Iterator<Object> iterator = lineCrossSizes.iterator();
        while (iterator.hasNext()) {
            float size = ((Float)iterator.next()).floatValue();
            flexLinesCrossSizesSum += size;
        }
        FlexUtil.handleAlignContentStretch(flexContainerRenderer, FlexUtil.isColumnDirection(flexContainerRenderer) ? new Float(layoutBoxCrossSize) : crossSize, flexLinesCrossSizesSum, lineCrossSizes);
        FlexUtil.determineUsedCrossSizeOfEachFlexItem(lines, lineCrossSizes, flexContainerRenderer);
        if (FlexUtil.isColumnDirection(flexContainerRenderer)) {
            if (containerMainSize > 0.0f) {
                FlexUtil.applyJustifyContent(lines, flexContainerRenderer, containerMainSize);
            }
        } else {
            FlexUtil.applyJustifyContent(lines, flexContainerRenderer, mainSize);
        }
        FlexUtil.applyAlignItemsAndAlignSelf(lines, flexContainerRenderer, lineCrossSizes);
        ArrayList<List<FlexItemInfo>> layoutTable = new ArrayList<List<FlexItemInfo>>();
        for (List<FlexItemCalculationInfo> line : lines) {
            ArrayList<FlexItemInfo> layoutLine = new ArrayList<FlexItemInfo>();
            for (FlexItemCalculationInfo info : line) {
                layoutLine.add(new FlexItemInfo(info.renderer, info.toRectangle()));
            }
            layoutTable.add(layoutLine);
        }
        return layoutTable;
    }

    static boolean isColumnDirection(FlexContainerRenderer renderer) {
        FlexDirectionPropertyValue flexDir = renderer.getProperty(139, FlexDirectionPropertyValue.ROW);
        return FlexDirectionPropertyValue.COLUMN == flexDir || FlexDirectionPropertyValue.COLUMN_REVERSE == flexDir;
    }

    private static float getMainSize(FlexContainerRenderer renderer, Rectangle layoutBox) {
        Float mainSize;
        float layoutBoxMainSize;
        boolean isColumnDirection = FlexUtil.isColumnDirection(renderer);
        Float maxDimension = null;
        Float minDimension = null;
        if (isColumnDirection) {
            layoutBoxMainSize = layoutBox.getHeight();
            mainSize = renderer.retrieveHeight();
            maxDimension = FlexUtil.resolveUnitValue(renderer, 84, layoutBoxMainSize);
            minDimension = FlexUtil.resolveUnitValue(renderer, 85, layoutBoxMainSize);
        } else {
            layoutBoxMainSize = layoutBox.getWidth();
            mainSize = renderer.retrieveWidth(layoutBoxMainSize);
            maxDimension = FlexUtil.resolveUnitValue(renderer, 79, layoutBoxMainSize);
            minDimension = FlexUtil.resolveUnitValue(renderer, 80, layoutBoxMainSize);
        }
        if (mainSize == null) {
            mainSize = Float.valueOf(layoutBoxMainSize);
        }
        if (minDimension != null && minDimension.floatValue() > mainSize.floatValue()) {
            mainSize = minDimension;
        }
        if (maxDimension != null && (minDimension == null || maxDimension.floatValue() > minDimension.floatValue()) && maxDimension.floatValue() < mainSize.floatValue()) {
            mainSize = maxDimension;
        }
        return mainSize.floatValue();
    }

    private static Float resolveUnitValue(FlexContainerRenderer renderer, int property, float baseValue) {
        UnitValue value = renderer.getPropertyAsUnitValue(property);
        if (value == null) {
            return null;
        }
        if (value.isPercentValue()) {
            return Float.valueOf(value.getValue() / 100.0f * baseValue);
        }
        return Float.valueOf(value.getValue());
    }

    private static Float[] getCrossSizes(FlexContainerRenderer renderer, Rectangle layoutBox) {
        boolean isColumnDirection = FlexUtil.isColumnDirection(renderer);
        return new Float[]{isColumnDirection ? renderer.retrieveWidth(layoutBox.getWidth()) : renderer.retrieveHeight(), isColumnDirection ? renderer.retrieveMinWidth(layoutBox.getWidth()) : renderer.retrieveMinHeight(), isColumnDirection ? renderer.retrieveMaxWidth(layoutBox.getWidth()) : renderer.retrieveMaxHeight()};
    }

    static void determineFlexBasisAndHypotheticalMainSizeForFlexItems(List<FlexItemCalculationInfo> flexItemCalculationInfos, float crossSize, boolean isColumnDirection) {
        for (FlexItemCalculationInfo info : flexItemCalculationInfos) {
            AbstractRenderer renderer = info.renderer;
            Float definiteCrossSize = null;
            if (renderer.hasAspectRatio()) {
                Float f = definiteCrossSize = isColumnDirection ? renderer.retrieveWidth(crossSize) : renderer.retrieveHeight();
            }
            if (info.flexBasisContent && definiteCrossSize != null) {
                float aspectRatio = renderer.getAspectRatio().floatValue();
                info.flexBaseSize = isColumnDirection ? definiteCrossSize.floatValue() / aspectRatio : definiteCrossSize.floatValue() * aspectRatio;
            } else {
                info.flexBaseSize = info.flexBasis;
            }
            info.mainSize = info.hypotheticalMainSize = Math.max(0.0f, Math.min(Math.max(info.minContent, info.flexBaseSize), info.maxContent));
        }
    }

    static List<List<FlexItemCalculationInfo>> collectFlexItemsIntoFlexLines(List<FlexItemCalculationInfo> flexItemCalculationInfos, float mainSize, boolean isSingleLine) {
        ArrayList<List<FlexItemCalculationInfo>> lines = new ArrayList<List<FlexItemCalculationInfo>>();
        ArrayList<FlexItemCalculationInfo> currentLineInfos = new ArrayList<FlexItemCalculationInfo>();
        if (isSingleLine) {
            currentLineInfos.addAll(flexItemCalculationInfos);
        } else {
            float occupiedLineSpace = 0.0f;
            for (FlexItemCalculationInfo info : flexItemCalculationInfos) {
                if ((occupiedLineSpace += info.getOuterMainSize(info.hypotheticalMainSize)) > mainSize + 1.0E-4f) {
                    if (currentLineInfos.isEmpty()) {
                        currentLineInfos.add(info);
                        lines.add(currentLineInfos);
                        currentLineInfos = new ArrayList();
                        occupiedLineSpace = 0.0f;
                        continue;
                    }
                    lines.add(currentLineInfos);
                    currentLineInfos = new ArrayList();
                    currentLineInfos.add(info);
                    occupiedLineSpace = info.getOuterMainSize(info.hypotheticalMainSize);
                    continue;
                }
                currentLineInfos.add(info);
            }
        }
        if (!currentLineInfos.isEmpty()) {
            lines.add(currentLineInfos);
        }
        return lines;
    }

    static void resolveFlexibleLengths(List<List<FlexItemCalculationInfo>> lines, float mainSize) {
        for (List<FlexItemCalculationInfo> line : lines) {
            float hypotheticalMainSizesSum = 0.0f;
            for (FlexItemCalculationInfo flexItemCalculationInfo : line) {
                hypotheticalMainSizesSum += flexItemCalculationInfo.getOuterMainSize(flexItemCalculationInfo.hypotheticalMainSize);
            }
            boolean isFlexGrow = hypotheticalMainSizesSum < mainSize;
            for (FlexItemCalculationInfo info3 : line) {
                if (isFlexGrow) {
                    if (!FlexUtil.isZero(info3.flexGrow) && !(info3.flexBaseSize > info3.hypotheticalMainSize)) continue;
                    info3.mainSize = info3.hypotheticalMainSize;
                    info3.isFrozen = true;
                    continue;
                }
                if (!FlexUtil.isZero(info3.flexShrink) && !(info3.flexBaseSize < info3.hypotheticalMainSize)) continue;
                info3.mainSize = info3.hypotheticalMainSize;
                info3.isFrozen = true;
            }
            float f = FlexUtil.calculateFreeSpace(line, mainSize);
            while (FlexUtil.hasFlexibleItems(line)) {
                float remainingFreeSpace = FlexUtil.calculateFreeSpace(line, mainSize);
                float flexFactorSum = 0.0f;
                for (FlexItemCalculationInfo flexItemCalculationInfo : line) {
                    if (flexItemCalculationInfo.isFrozen) continue;
                    flexFactorSum += isFlexGrow ? flexItemCalculationInfo.flexGrow : flexItemCalculationInfo.flexShrink;
                }
                if (flexFactorSum < 1.0f && Math.abs(remainingFreeSpace) > Math.abs(f * flexFactorSum)) {
                    remainingFreeSpace = f * flexFactorSum;
                }
                if (!FlexUtil.isZero(remainingFreeSpace)) {
                    float ratio;
                    float scaledFlexShrinkFactorsSum = 0.0f;
                    for (FlexItemCalculationInfo info5 : line) {
                        if (info5.isFrozen) continue;
                        if (isFlexGrow) {
                            ratio = info5.flexGrow / flexFactorSum;
                            info5.mainSize = info5.flexBaseSize + remainingFreeSpace * ratio;
                            continue;
                        }
                        info5.scaledFlexShrinkFactor = info5.flexShrink * info5.flexBaseSize;
                        scaledFlexShrinkFactorsSum += info5.scaledFlexShrinkFactor;
                    }
                    if (!FlexUtil.isZero(scaledFlexShrinkFactorsSum)) {
                        for (FlexItemCalculationInfo info : line) {
                            if (info.isFrozen || isFlexGrow) continue;
                            ratio = info.scaledFlexShrinkFactor / scaledFlexShrinkFactorsSum;
                            info.mainSize = info.flexBaseSize - Math.abs(remainingFreeSpace) * ratio;
                        }
                    }
                } else {
                    for (FlexItemCalculationInfo flexItemCalculationInfo : line) {
                        if (flexItemCalculationInfo.isFrozen) continue;
                        flexItemCalculationInfo.mainSize = flexItemCalculationInfo.flexBaseSize;
                    }
                }
                float sum = 0.0f;
                for (FlexItemCalculationInfo info : line) {
                    if (info.isFrozen) continue;
                    float clampedSize = Math.min(Math.max(info.mainSize, info.minContent), info.maxContent);
                    if (info.mainSize > clampedSize) {
                        info.isMaxViolated = true;
                    } else if (info.mainSize < clampedSize) {
                        info.isMinViolated = true;
                    }
                    sum += clampedSize - info.mainSize;
                    info.mainSize = clampedSize;
                }
                for (FlexItemCalculationInfo info : line) {
                    if (info.isFrozen || !(FlexUtil.isZero(sum) || 0.0f < sum && info.isMinViolated) && (!(0.0f > sum) || !info.isMaxViolated)) continue;
                    info.isFrozen = true;
                }
            }
        }
    }

    static void determineHypotheticalCrossSizeForFlexItems(List<List<FlexItemCalculationInfo>> lines, boolean isColumnDirection, float crossSize) {
        for (List<FlexItemCalculationInfo> line : lines) {
            for (FlexItemCalculationInfo info : line) {
                FlexUtil.determineHypotheticalCrossSizeForFlexItem(info, isColumnDirection, crossSize);
            }
        }
    }

    private static void determineHypotheticalCrossSizeForFlexItem(FlexItemCalculationInfo info, boolean isColumnDirection, float crossSize) {
        if (info.renderer instanceof FlexContainerRenderer && ((FlexContainerRenderer)info.renderer).getHypotheticalCrossSize(Float.valueOf(info.mainSize)) != null) {
            info.hypotheticalCrossSize = ((FlexContainerRenderer)info.renderer).getHypotheticalCrossSize(Float.valueOf(info.mainSize)).floatValue();
        } else if (isColumnDirection) {
            MinMaxWidth minMaxWidth = info.renderer.getMinMaxWidth();
            info.hypotheticalCrossSize = info.getInnerCrossSize(Math.max(Math.min(minMaxWidth.getMaxWidth(), crossSize), minMaxWidth.getMinWidth()));
            if (info.renderer instanceof FlexContainerRenderer) {
                ((FlexContainerRenderer)info.renderer).setHypotheticalCrossSize(Float.valueOf(info.mainSize), Float.valueOf(info.hypotheticalCrossSize));
            }
        } else {
            UnitValue prevMainSize = info.renderer.replaceOwnProperty(77, UnitValue.createPointValue(info.mainSize));
            UnitValue prevMinMainSize = info.renderer.replaceOwnProperty(80, null);
            info.renderer.setProperty(136, (Object)InlineVerticalAlignmentType.BOTTOM);
            LayoutResult result = info.renderer.layout(new LayoutContext(new LayoutArea(0, new Rectangle(1000000.0f, 1000000.0f))));
            info.renderer.returnBackOwnProperty(80, prevMinMainSize);
            info.renderer.returnBackOwnProperty(77, prevMainSize);
            if (result.getStatus() == 1) {
                info.hypotheticalCrossSize = info.getInnerCrossSize(result.getOccupiedArea().getBBox().getHeight());
                if (info.renderer instanceof FlexContainerRenderer) {
                    ((FlexContainerRenderer)info.renderer).setHypotheticalCrossSize(Float.valueOf(info.mainSize), Float.valueOf(info.hypotheticalCrossSize));
                }
            } else {
                logger.error("Flex item layout result isn't full, but it must be. The cross size of the flex item will be 0.");
                info.hypotheticalCrossSize = 0.0f;
            }
        }
    }

    static List<Float> calculateCrossSizeOfEachFlexLine(List<List<FlexItemCalculationInfo>> lines, Float minCrossSize, Float crossSize, Float maxCrossSize) {
        boolean isSingleLine = lines.size() == 1;
        ArrayList<Float> lineCrossSizes = new ArrayList<Float>();
        if (isSingleLine && crossSize != null && !lines.isEmpty()) {
            lineCrossSizes.add(Float.valueOf(crossSize.floatValue()));
        } else {
            for (List<FlexItemCalculationInfo> line : lines) {
                float flexLinesCrossSize = 0.0f;
                float largestHypotheticalCrossSize = 0.0f;
                for (FlexItemCalculationInfo info : line) {
                    if (largestHypotheticalCrossSize < info.getOuterCrossSize(info.hypotheticalCrossSize)) {
                        largestHypotheticalCrossSize = info.getOuterCrossSize(info.hypotheticalCrossSize);
                    }
                    flexLinesCrossSize = Math.max(0.0f, largestHypotheticalCrossSize);
                }
                if (isSingleLine && !lines.isEmpty()) {
                    if (null != minCrossSize) {
                        flexLinesCrossSize = Math.max(minCrossSize.floatValue(), flexLinesCrossSize);
                    }
                    if (null != maxCrossSize) {
                        flexLinesCrossSize = Math.min(maxCrossSize.floatValue(), flexLinesCrossSize);
                    }
                }
                lineCrossSizes.add(Float.valueOf(flexLinesCrossSize));
            }
        }
        return lineCrossSizes;
    }

    static void handleAlignContentStretch(FlexContainerRenderer flexContainerRenderer, Float crossSize, float flexLinesCrossSizesSum, List<Float> lineCrossSizes) {
        AlignmentPropertyValue alignContent = flexContainerRenderer.getProperty(130, AlignmentPropertyValue.STRETCH);
        if (crossSize != null && alignContent == AlignmentPropertyValue.STRETCH && flexLinesCrossSizesSum < crossSize.floatValue() - 1.0E-4f) {
            float addition = (crossSize.floatValue() - flexLinesCrossSizesSum) / (float)lineCrossSizes.size();
            for (int i = 0; i < lineCrossSizes.size(); ++i) {
                lineCrossSizes.set(i, Float.valueOf(lineCrossSizes.get(i).floatValue() + addition));
            }
        }
    }

    static void determineUsedCrossSizeOfEachFlexItem(List<List<FlexItemCalculationInfo>> lines, List<Float> lineCrossSizes, FlexContainerRenderer flexContainerRenderer) {
        boolean isColumnDirection = FlexUtil.isColumnDirection(flexContainerRenderer);
        AlignmentPropertyValue alignItems = flexContainerRenderer.getProperty(134, AlignmentPropertyValue.STRETCH);
        assert (lines.size() == lineCrossSizes.size());
        for (int i = 0; i < lines.size(); ++i) {
            for (FlexItemCalculationInfo info : lines.get(i)) {
                boolean definiteCrossSize;
                AbstractRenderer infoRenderer = info.renderer;
                AlignmentPropertyValue alignSelf = infoRenderer.getProperty(129, alignItems);
                boolean bl = definiteCrossSize = isColumnDirection ? info.renderer.hasProperty(77) : info.renderer.hasProperty(27);
                if (!(alignSelf != AlignmentPropertyValue.STRETCH && alignSelf != AlignmentPropertyValue.NORMAL || definiteCrossSize)) {
                    Float minCrossSize;
                    Float maxCrossSize;
                    info.crossSize = info.getInnerCrossSize(lineCrossSizes.get(i).floatValue());
                    Float f = maxCrossSize = isColumnDirection ? infoRenderer.retrieveMaxWidth(lineCrossSizes.get(i).floatValue()) : infoRenderer.retrieveMaxHeight();
                    if (maxCrossSize != null) {
                        info.crossSize = Math.min(maxCrossSize.floatValue(), info.crossSize);
                    }
                    if ((minCrossSize = isColumnDirection ? infoRenderer.retrieveMinWidth(lineCrossSizes.get(i).floatValue()) : infoRenderer.retrieveMinHeight()) == null) continue;
                    info.crossSize = Math.max(minCrossSize.floatValue(), info.crossSize);
                    continue;
                }
                info.crossSize = info.hypotheticalCrossSize;
            }
        }
    }

    private static Float retrieveMaxHeightForMainDirection(AbstractRenderer renderer) {
        Float maxHeight = renderer.retrieveMaxHeight();
        return renderer.hasProperty(84) ? maxHeight : null;
    }

    private static Float retrieveMinHeightForMainDirection(AbstractRenderer renderer) {
        Float minHeight = renderer.retrieveMinHeight();
        return renderer.hasProperty(85) ? minHeight : null;
    }

    private static void applyAlignItemsAndAlignSelf(List<List<FlexItemCalculationInfo>> lines, FlexContainerRenderer renderer, List<Float> lineCrossSizes) {
        boolean isColumnDirection = FlexUtil.isColumnDirection(renderer);
        AlignmentPropertyValue itemsAlignment = renderer.getProperty(134, AlignmentPropertyValue.STRETCH);
        assert (lines.size() == lineCrossSizes.size());
        if (renderer.isWrapReverse()) {
            Collections.reverse(lines);
            Collections.reverse(lineCrossSizes);
        }
        float nextLineShift = 0.0f;
        for (int i = 0; i < lines.size(); ++i) {
            float lineShift = nextLineShift;
            List<FlexItemCalculationInfo> line = lines.get(i);
            float lineCrossSize = lineCrossSizes.get(i).floatValue();
            nextLineShift = lineCrossSize - line.get(0).getOuterCrossSize(line.get((int)0).crossSize);
            for (FlexItemCalculationInfo itemInfo : line) {
                if (isColumnDirection) {
                    itemInfo.xShift = lineShift;
                } else {
                    itemInfo.yShift = lineShift;
                }
                AlignmentPropertyValue selfAlignment = itemInfo.renderer.getProperty(129, itemsAlignment);
                float freeSpace = lineCrossSize - itemInfo.getOuterCrossSize(itemInfo.crossSize);
                nextLineShift = Math.min(nextLineShift, freeSpace);
                switch (selfAlignment) {
                    case SELF_END: 
                    case END: {
                        if (isColumnDirection) {
                            itemInfo.xShift += freeSpace;
                        } else {
                            itemInfo.yShift += freeSpace;
                        }
                        nextLineShift = 0.0f;
                        break;
                    }
                    case FLEX_END: {
                        if (renderer.isWrapReverse()) break;
                        if (isColumnDirection) {
                            itemInfo.xShift += freeSpace;
                        } else {
                            itemInfo.yShift += freeSpace;
                        }
                        nextLineShift = 0.0f;
                        break;
                    }
                    case CENTER: {
                        if (isColumnDirection) {
                            itemInfo.xShift += freeSpace / 2.0f;
                        } else {
                            itemInfo.yShift += freeSpace / 2.0f;
                        }
                        nextLineShift = Math.min(nextLineShift, freeSpace / 2.0f);
                        break;
                    }
                    case FLEX_START: {
                        if (!renderer.isWrapReverse()) break;
                        if (isColumnDirection) {
                            itemInfo.xShift += freeSpace;
                        } else {
                            itemInfo.yShift += freeSpace;
                        }
                        nextLineShift = 0.0f;
                        break;
                    }
                }
            }
        }
        if (renderer.isWrapReverse()) {
            Collections.reverse(lines);
            Collections.reverse(lineCrossSizes);
        }
    }

    private static void applyJustifyContent(List<List<FlexItemCalculationInfo>> lines, FlexContainerRenderer renderer, float mainSize) {
        JustifyContent justifyContent = renderer.getProperty(133, JustifyContent.FLEX_START);
        for (List<FlexItemCalculationInfo> line : lines) {
            float childrenMainSize = 0.0f;
            for (FlexItemCalculationInfo itemInfo : line) {
                childrenMainSize += itemInfo.getOuterMainSize(itemInfo.mainSize);
            }
            float freeSpace = mainSize - childrenMainSize;
            renderer.getFlexItemMainDirector().applyJustifyContent(line, justifyContent, freeSpace);
        }
    }

    private static float calculateFreeSpace(List<FlexItemCalculationInfo> line, float initialFreeSpace) {
        float result = initialFreeSpace;
        for (FlexItemCalculationInfo info : line) {
            if (info.isFrozen) {
                result -= info.getOuterMainSize(info.mainSize);
                continue;
            }
            result -= info.getOuterMainSize(info.flexBaseSize);
        }
        return result;
    }

    private static boolean hasFlexibleItems(List<FlexItemCalculationInfo> line) {
        for (FlexItemCalculationInfo info : line) {
            if (info.isFrozen) continue;
            return true;
        }
        return false;
    }

    static boolean isZero(float value) {
        return Math.abs(value) < 1.0E-4f;
    }

    private static List<FlexItemCalculationInfo> createFlexItemCalculationInfos(FlexContainerRenderer flexContainerRenderer, float flexContainerMainSize, float crossSize) {
        List<IRenderer> childRenderers = flexContainerRenderer.getChildRenderers();
        ArrayList<FlexItemCalculationInfo> flexItems = new ArrayList<FlexItemCalculationInfo>();
        for (IRenderer renderer : childRenderers) {
            float flexBasis;
            if (!(renderer instanceof AbstractRenderer)) continue;
            AbstractRenderer abstractRenderer = (AbstractRenderer)renderer;
            float maxMainSize = FlexUtil.calculateMaxMainSize(abstractRenderer, flexContainerMainSize, FlexUtil.isColumnDirection(flexContainerRenderer), crossSize);
            boolean flexBasisContent = false;
            if (renderer.getProperty(131) == null) {
                flexBasis = maxMainSize;
                flexBasisContent = true;
            } else {
                float containerMainSize = FlexUtil.isColumnDirection(flexContainerRenderer) ? FlexUtil.getMainSize(flexContainerRenderer, new Rectangle(0.0f, 0.0f)) : flexContainerMainSize;
                flexBasis = abstractRenderer.retrieveUnitValue(containerMainSize, 131).floatValue();
                if (AbstractRenderer.isBorderBoxSizing(abstractRenderer)) {
                    flexBasis -= AbstractRenderer.calculatePaddingBorderWidth(abstractRenderer);
                }
            }
            flexBasis = Math.max(flexBasis, 0.0f);
            float flexGrow = renderer.getProperty(132, Float.valueOf(0.0f)).floatValue();
            float flexShrink = renderer.getProperty(127, Float.valueOf(1.0f)).floatValue();
            FlexItemCalculationInfo flexItemInfo = new FlexItemCalculationInfo((AbstractRenderer)renderer, flexBasis, flexGrow, flexShrink, flexContainerMainSize, flexBasisContent, FlexUtil.isColumnDirection(flexContainerRenderer), crossSize);
            flexItems.add(flexItemInfo);
        }
        return flexItems;
    }

    private static float calculateMaxMainSize(AbstractRenderer flexItemRenderer, float flexContainerMainSize, boolean isColumnDirection, float crossSize) {
        Float maxMainSize;
        if (flexItemRenderer instanceof TableRenderer) {
            if (isColumnDirection) {
                Float itemRendererMaxHeight = flexItemRenderer.retrieveMaxHeight();
                maxMainSize = itemRendererMaxHeight;
                if (maxMainSize == null) {
                    maxMainSize = Float.valueOf(FlexUtil.calculateHeight(flexItemRenderer, crossSize));
                }
            } else {
                maxMainSize = new Float(flexItemRenderer.getMinMaxWidth().getMaxWidth());
            }
            maxMainSize = isColumnDirection ? Float.valueOf(flexItemRenderer.applyMarginsBordersPaddings(new Rectangle(0.0f, maxMainSize.floatValue()), false).getHeight()) : Float.valueOf(flexItemRenderer.applyMarginsBordersPaddings(new Rectangle(maxMainSize.floatValue(), 0.0f), false).getWidth());
        } else {
            Float f = maxMainSize = isColumnDirection ? flexItemRenderer.retrieveHeight() : flexItemRenderer.retrieveWidth(flexContainerMainSize);
            if (maxMainSize == null) {
                Float f2 = maxMainSize = isColumnDirection ? FlexUtil.retrieveMaxHeightForMainDirection(flexItemRenderer) : flexItemRenderer.retrieveMaxWidth(flexContainerMainSize);
            }
            if (maxMainSize == null) {
                if (flexItemRenderer instanceof ImageRenderer) {
                    maxMainSize = Float.valueOf(isColumnDirection ? ((ImageRenderer)flexItemRenderer).getImageHeight() : ((ImageRenderer)flexItemRenderer).getImageWidth());
                } else if (isColumnDirection) {
                    Float height = FlexUtil.retrieveMaxHeightForMainDirection(flexItemRenderer);
                    if (height == null) {
                        height = Float.valueOf(FlexUtil.calculateHeight(flexItemRenderer, crossSize));
                    }
                    maxMainSize = Float.valueOf(flexItemRenderer.applyMarginsBordersPaddings(new Rectangle(0.0f, height.floatValue()), false).getHeight());
                } else {
                    maxMainSize = Float.valueOf(flexItemRenderer.applyMarginsBordersPaddings(new Rectangle(flexItemRenderer.getMinMaxWidth().getMaxWidth(), 0.0f), false).getWidth());
                }
            }
        }
        return maxMainSize.floatValue();
    }

    private static float calculateHeight(AbstractRenderer flexItemRenderer, float width) {
        LayoutResult result = flexItemRenderer.layout(new LayoutContext(new LayoutArea(1, new Rectangle(width, 1000000.0f))));
        return result.getStatus() == 3 ? 0.0f : result.getOccupiedArea().getBBox().getHeight();
    }

    static class FlexItemCalculationInfo {
        AbstractRenderer renderer;
        float flexBasis;
        float flexShrink;
        float flexGrow;
        float minContent;
        float maxContent;
        float mainSize;
        float crossSize;
        float xShift;
        float yShift;
        float scaledFlexShrinkFactor;
        boolean isFrozen = false;
        boolean isMinViolated = false;
        boolean isMaxViolated = false;
        float flexBaseSize;
        float hypotheticalMainSize;
        float hypotheticalCrossSize;
        boolean flexBasisContent;
        boolean isColumnDirection;

        public FlexItemCalculationInfo(AbstractRenderer renderer, float flexBasis, float flexGrow, float flexShrink, float areaMainSize, boolean flexBasisContent, boolean isColumnDirection, float crossSize) {
            this.isColumnDirection = isColumnDirection;
            this.flexBasisContent = flexBasisContent;
            this.renderer = renderer;
            this.flexBasis = flexBasis;
            if (flexShrink < 0.0f) {
                throw new IllegalArgumentException("Flex shrink cannot be negative.");
            }
            this.flexShrink = flexShrink;
            if (flexGrow < 0.0f) {
                throw new IllegalArgumentException("Flex grow cannot be negative.");
            }
            this.flexGrow = flexGrow;
            Float definiteMinContent = isColumnDirection ? FlexUtil.retrieveMinHeightForMainDirection(renderer) : renderer.retrieveMinWidth(areaMainSize);
            this.minContent = definiteMinContent == null ? this.calculateMinContentAuto(areaMainSize, crossSize) : definiteMinContent.floatValue();
            Float maxMainSize = isColumnDirection ? FlexUtil.retrieveMaxHeightForMainDirection(this.renderer) : this.renderer.retrieveMaxWidth(areaMainSize);
            this.maxContent = maxMainSize == null ? 1000000.0f : maxMainSize.floatValue();
        }

        public Rectangle toRectangle() {
            return this.isColumnDirection ? new Rectangle(this.xShift, this.yShift, this.getOuterCrossSize(this.crossSize), this.getOuterMainSize(this.mainSize)) : new Rectangle(this.xShift, this.yShift, this.getOuterMainSize(this.mainSize), this.getOuterCrossSize(this.crossSize));
        }

        float getOuterMainSize(float size) {
            return this.isColumnDirection ? this.renderer.applyMarginsBordersPaddings(new Rectangle(0.0f, size), true).getHeight() : this.renderer.applyMarginsBordersPaddings(new Rectangle(size, 0.0f), true).getWidth();
        }

        float getInnerMainSize(float size) {
            return this.isColumnDirection ? this.renderer.applyMarginsBordersPaddings(new Rectangle(0.0f, size), false).getHeight() : this.renderer.applyMarginsBordersPaddings(new Rectangle(size, 0.0f), false).getWidth();
        }

        float getOuterCrossSize(float size) {
            return this.isColumnDirection ? this.renderer.applyMarginsBordersPaddings(new Rectangle(size, 0.0f), true).getWidth() : this.renderer.applyMarginsBordersPaddings(new Rectangle(0.0f, size), true).getHeight();
        }

        float getInnerCrossSize(float size) {
            return this.isColumnDirection ? this.renderer.applyMarginsBordersPaddings(new Rectangle(size, 0.0f), false).getWidth() : this.renderer.applyMarginsBordersPaddings(new Rectangle(0.0f, size), false).getHeight();
        }

        private float calculateMinContentAuto(float flexContainerMainSize, float crossSize) {
            Float specifiedSizeSuggestion = this.calculateSpecifiedSizeSuggestion(flexContainerMainSize);
            float contentSizeSuggestion = this.calculateContentSizeSuggestion(flexContainerMainSize, crossSize);
            if (this.renderer.hasAspectRatio() && specifiedSizeSuggestion == null) {
                Float transferredSizeSuggestion = this.calculateTransferredSizeSuggestion(flexContainerMainSize);
                if (transferredSizeSuggestion == null) {
                    return contentSizeSuggestion;
                }
                return Math.min(contentSizeSuggestion, transferredSizeSuggestion.floatValue());
            }
            if (specifiedSizeSuggestion == null) {
                return contentSizeSuggestion;
            }
            return Math.min(contentSizeSuggestion, specifiedSizeSuggestion.floatValue());
        }

        private Float calculateTransferredSizeSuggestion(float flexContainerMainSize) {
            Float crossSize;
            Float transferredSizeSuggestion = null;
            Float f = crossSize = this.isColumnDirection ? this.renderer.retrieveWidth(flexContainerMainSize) : this.renderer.retrieveHeight();
            if (this.renderer.hasAspectRatio() && crossSize != null) {
                transferredSizeSuggestion = Float.valueOf(crossSize.floatValue() * this.renderer.getAspectRatio().floatValue());
                transferredSizeSuggestion = Float.valueOf(this.clampValueByCrossSizesConvertedThroughAspectRatio(transferredSizeSuggestion.floatValue(), flexContainerMainSize));
            }
            return transferredSizeSuggestion;
        }

        private Float calculateSpecifiedSizeSuggestion(float flexContainerMainSize) {
            Float mainSizeSuggestion = null;
            if (this.isColumnDirection) {
                if (this.renderer.hasProperty(27)) {
                    mainSizeSuggestion = this.renderer.retrieveHeight();
                }
            } else if (this.renderer.hasProperty(77)) {
                mainSizeSuggestion = this.renderer.retrieveWidth(flexContainerMainSize);
            }
            return mainSizeSuggestion;
        }

        private float calculateContentSizeSuggestion(float flexContainerMainSize, float crossSize) {
            Float maxMainSize;
            float minContentSize;
            UnitValue rendererWidth = this.renderer.replaceOwnProperty(77, null);
            UnitValue rendererHeight = this.renderer.replaceOwnProperty(27, null);
            if (this.isColumnDirection) {
                Float height = FlexUtil.retrieveMinHeightForMainDirection(this.renderer);
                if (height == null) {
                    height = Float.valueOf(FlexUtil.calculateHeight(this.renderer, crossSize));
                }
                minContentSize = this.getInnerMainSize(height.floatValue());
            } else {
                MinMaxWidth minMaxWidth = this.renderer.getMinMaxWidth();
                minContentSize = this.getInnerMainSize(minMaxWidth.getMinWidth());
            }
            this.renderer.returnBackOwnProperty(27, rendererHeight);
            this.renderer.returnBackOwnProperty(77, rendererWidth);
            if (this.renderer.hasAspectRatio()) {
                minContentSize = this.clampValueByCrossSizesConvertedThroughAspectRatio(minContentSize, flexContainerMainSize);
            }
            Float f = maxMainSize = this.isColumnDirection ? FlexUtil.retrieveMaxHeightForMainDirection(this.renderer) : this.renderer.retrieveMaxWidth(flexContainerMainSize);
            if (maxMainSize == null) {
                maxMainSize = Float.valueOf(1000000.0f);
            }
            return Math.min(minContentSize, maxMainSize.floatValue());
        }

        private float clampValueByCrossSizesConvertedThroughAspectRatio(float value, float flexContainerMainSize) {
            Float minCrossSize;
            Float maxCrossSize;
            Float f = maxCrossSize = this.isColumnDirection ? this.renderer.retrieveMaxWidth(flexContainerMainSize) : this.renderer.retrieveMaxHeight();
            if (maxCrossSize == null || !this.renderer.hasProperty(this.isColumnDirection ? 79 : 84)) {
                maxCrossSize = Float.valueOf(1000000.0f);
            }
            Float f2 = minCrossSize = this.isColumnDirection ? this.renderer.retrieveMinWidth(flexContainerMainSize) : this.renderer.retrieveMinHeight();
            if (minCrossSize == null || !this.renderer.hasProperty(this.isColumnDirection ? 80 : 85)) {
                minCrossSize = Float.valueOf(0.0f);
            }
            return Math.min(Math.max(minCrossSize.floatValue() * this.renderer.getAspectRatio().floatValue(), value), maxCrossSize.floatValue() * this.renderer.getAspectRatio().floatValue());
        }
    }
}

