/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.impl;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.css.apply.ICssApplier;
import com.itextpdf.html2pdf.css.apply.util.BackgroundApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.BorderStyleApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.FloatApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.FontStyleApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.HyphenationApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.MarginApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.OpacityApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.OutlineApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.PaddingApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.PositionApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.VerticalAlignmentApplierUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import java.util.Map;

public class SpanTagCssApplier
implements ICssApplier {
    @Override
    public void apply(ProcessorContext context, IStylesContainer stylesContainer, ITagWorker tagWorker) {
        String floatVal;
        SpanTagWorker spanTagWorker = (SpanTagWorker)tagWorker;
        Map cssStyles = stylesContainer.getStyles();
        for (IPropertyContainer child : spanTagWorker.getOwnLeafElements()) {
            if (child instanceof IFormField) continue;
            this.applyChildElementStyles(child, cssStyles, context, stylesContainer);
        }
        VerticalAlignmentApplierUtil.applyVerticalAlignmentForInlines(cssStyles, context, stylesContainer, spanTagWorker.getAllElements());
        if (cssStyles.containsKey("opacity")) {
            for (IPropertyContainer elem : spanTagWorker.getAllElements()) {
                if (!(elem instanceof Text) || elem.hasProperty(92)) continue;
                OpacityApplierUtil.applyOpacity(cssStyles, context, elem);
            }
        }
        if ((floatVal = (String)cssStyles.get("float")) != null && !"none".equals(floatVal)) {
            for (IPropertyContainer elem : spanTagWorker.getAllElements()) {
                FloatPropertyValue kidFloatVal = (FloatPropertyValue)elem.getProperty(99);
                if (kidFloatVal != null && !FloatPropertyValue.NONE.equals((Object)kidFloatVal)) continue;
                FloatApplierUtil.applyFloating(cssStyles, context, elem);
            }
        }
    }

    protected void applyChildElementStyles(IPropertyContainer element, Map<String, String> css, ProcessorContext context, IStylesContainer stylesContainer) {
        FontStyleApplierUtil.applyFontStyles(css, context, stylesContainer, element);
        BackgroundApplierUtil.applyBackground(css, context, element);
        BorderStyleApplierUtil.applyBorders(css, context, element);
        OutlineApplierUtil.applyOutlines(css, context, element);
        HyphenationApplierUtil.applyHyphenation(css, context, stylesContainer, element);
        MarginApplierUtil.applyMargins(css, context, element);
        PositionApplierUtil.applyPosition(css, context, element);
        FloatApplierUtil.applyFloating(css, context, element);
        PaddingApplierUtil.applyPaddings(css, context, element);
    }
}

