/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfChoiceFormField
extends PdfFormField {
    public static final int FF_COMBO = PdfChoiceFormField.makeFieldFlag(18);
    public static final int FF_EDIT = PdfChoiceFormField.makeFieldFlag(19);
    public static final int FF_SORT = PdfChoiceFormField.makeFieldFlag(20);
    public static final int FF_MULTI_SELECT = PdfChoiceFormField.makeFieldFlag(22);
    public static final int FF_DO_NOT_SPELL_CHECK = PdfChoiceFormField.makeFieldFlag(23);
    public static final int FF_COMMIT_ON_SEL_CHANGE = PdfChoiceFormField.makeFieldFlag(27);

    protected PdfChoiceFormField(PdfDocument pdfDocument) {
        super(pdfDocument);
    }

    protected PdfChoiceFormField(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        super(widget, pdfDocument);
    }

    protected PdfChoiceFormField(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getFormType() {
        return PdfName.Ch;
    }

    public PdfChoiceFormField setTopIndex(int index) {
        this.put(PdfName.TI, (PdfObject)new PdfNumber(index));
        this.regenerateField();
        return this;
    }

    public PdfNumber getTopIndex() {
        return this.getPdfObject().getAsNumber(PdfName.TI);
    }

    public PdfChoiceFormField setIndices(PdfArray indices) {
        this.put(PdfName.I, (PdfObject)indices);
        return this;
    }

    public PdfChoiceFormField setListSelected(String[] optionValues) {
        return this.setListSelected(optionValues, true);
    }

    public PdfChoiceFormField setListSelected(String[] optionValues, boolean generateAppearance) {
        if (optionValues.length > 1 && !this.isMultiSelect()) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.warn("Multiple values were set to a field that does not have MultiSelect flag set.");
        }
        PdfArray options = this.getOptions();
        PdfArray indices = new PdfArray();
        PdfArray values = new PdfArray();
        List<String> optionsToUnicodeNames = this.optionsToUnicodeNames();
        for (String element : optionValues) {
            if (element == null) continue;
            if (optionsToUnicodeNames.contains(element)) {
                int index = optionsToUnicodeNames.indexOf(element);
                indices.add((PdfObject)new PdfNumber(index));
                PdfObject optByIndex = options.get(index);
                values.add((PdfObject)(optByIndex.isString() ? (PdfString)optByIndex : (PdfString)((PdfArray)optByIndex).get(1)));
                continue;
            }
            if (!this.isCombo() || !this.isEdit()) {
                Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
                logger.warn(MessageFormatUtil.format((String)"Value \"{0}\" is not contained in /Opt array of field \"{1}\".", (Object[])new Object[]{element, this.getFieldName()}));
            }
            values.add((PdfObject)new PdfString(element, "UnicodeBig"));
        }
        if (indices.size() > 0) {
            this.setIndices(indices);
        } else {
            this.remove(PdfName.I);
        }
        if (values.size() == 1) {
            this.put(PdfName.V, values.get(0));
        } else {
            this.put(PdfName.V, (PdfObject)values);
        }
        if (generateAppearance) {
            this.regenerateField();
        }
        return this;
    }

    public PdfChoiceFormField setListSelected(int[] optionNumbers) {
        if (optionNumbers.length > 1 && !this.isMultiSelect()) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.warn("Multiple values were set to a field that does not have MultiSelect flag set.");
        }
        PdfArray indices = new PdfArray();
        PdfArray values = new PdfArray();
        PdfArray options = this.getOptions();
        for (int number : optionNumbers) {
            if (number < 0 || number >= options.size()) continue;
            indices.add((PdfObject)new PdfNumber(number));
            PdfObject option = options.get(number);
            if (option.isString()) {
                values.add(option);
                continue;
            }
            if (!option.isArray()) continue;
            values.add(((PdfArray)option).get(0));
        }
        if (indices.size() > 0) {
            this.setIndices(indices);
            if (values.size() == 1) {
                this.put(PdfName.V, values.get(0));
            } else {
                this.put(PdfName.V, (PdfObject)values);
            }
        } else {
            this.remove(PdfName.I);
            this.remove(PdfName.V);
        }
        this.regenerateField();
        return this;
    }

    public PdfArray getIndices() {
        return this.getPdfObject().getAsArray(PdfName.I);
    }

    public PdfChoiceFormField setCombo(boolean combo) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_COMBO, combo);
    }

    public boolean isCombo() {
        return this.getFieldFlag(FF_COMBO);
    }

    public PdfChoiceFormField setEdit(boolean edit) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_EDIT, edit);
    }

    public boolean isEdit() {
        return this.getFieldFlag(FF_EDIT);
    }

    public PdfChoiceFormField setSort(boolean sort) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_SORT, sort);
    }

    public boolean isSort() {
        return this.getFieldFlag(FF_SORT);
    }

    public PdfChoiceFormField setMultiSelect(boolean multiSelect) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_MULTI_SELECT, multiSelect);
    }

    public boolean isMultiSelect() {
        return this.getFieldFlag(FF_MULTI_SELECT);
    }

    public PdfChoiceFormField setSpellCheck(boolean spellCheck) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_DO_NOT_SPELL_CHECK, !spellCheck);
    }

    public boolean isSpellCheck() {
        return !this.getFieldFlag(FF_DO_NOT_SPELL_CHECK);
    }

    public PdfChoiceFormField setCommitOnSelChange(boolean commitOnSelChange) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_COMMIT_ON_SEL_CHANGE, commitOnSelChange);
    }

    public boolean isCommitOnSelChange() {
        return this.getFieldFlag(FF_COMMIT_ON_SEL_CHANGE);
    }

    private List<String> optionsToUnicodeNames() {
        PdfArray options = this.getOptions();
        ArrayList<String> optionsToUnicodeNames = new ArrayList<String>(options.size());
        for (int index = 0; index < options.size(); ++index) {
            PdfObject option = options.get(index);
            PdfString value = null;
            if (option.isString()) {
                value = (PdfString)option;
            } else if (option.isArray() && ((PdfArray)option).size() > 1) {
                value = (PdfString)((PdfArray)option).get(1);
            }
            optionsToUnicodeNames.add(value != null ? value.toUnicodeString() : null);
        }
        return optionsToUnicodeNames;
    }
}

