/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.builder.BaseMapperConfigBuilder;

public class MapperJavaProxy
implements InvocationHandler {
    protected SQLManager sqlManager;
    protected Class<?> entityClass;
    protected BaseMapperConfigBuilder builder;
    protected Class mapperInterface;
    private static final Map<Class, Object> PROVIDERS_CACHE = new ConcurrentHashMap<Class, Object>();

    public MapperJavaProxy() {
    }

    public MapperJavaProxy(BaseMapperConfigBuilder builder, SQLManager sqlManager, Class<?> mapperInterface) {
        this.sqlManager = sqlManager;
        this.builder = builder;
        this.mapperInterface(mapperInterface);
        this.mapperInterface = mapperInterface;
    }

    public MapperJavaProxy mapperInterface(Class<?> mapperInterface) {
        this.onResolveEntityClassFromMapperInterface(mapperInterface);
        return this;
    }

    public MapperJavaProxy entityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    protected void checkArgs() {
    }

    public MapperJavaProxy build() {
        this.checkArgs();
        return this;
    }

    protected void onResolveEntityClassFromMapperInterface(Class<?> mapperInterface) {
        if (!mapperInterface.isInterface()) {
            throw new IllegalArgumentException("mapperInterface is not interface.");
        }
        this.entityClass = BeanKit.getMapperEntity(mapperInterface);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> caller = method.getDeclaringClass();
        MapperInvoke invoke = this.builder.getAmi(this.entityClass, caller, method);
        Object ret = invoke.call(this.sqlManager, this.entityClass, method, args);
        return ret;
    }
}

