/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.type;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.PrimitiveValue;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;
import org.beetl.sql.core.mapping.type.WriteTypeParameter;

public class IntegerTypeHandler
extends JavaSqlTypeHandler
implements PrimitiveValue {
    static Integer defaultValue = 0;

    @Override
    public Object getValue(ReadTypeParameter typePara) throws SQLException {
        ResultSet rs = typePara.rs;
        int a = rs.getInt(typePara.index);
        if (a != 0) {
            return a;
        }
        if (rs.wasNull()) {
            if (typePara.isPrimitive()) {
                return defaultValue;
            }
            return null;
        }
        return a;
    }

    @Override
    public Object getDefaultValue() {
        return defaultValue;
    }

    @Override
    public void setParameter(WriteTypeParameter writeTypeParameter, Object obj) throws SQLException {
        writeTypeParameter.getPs().setInt(writeTypeParameter.getIndex(), (Integer)obj);
    }

    @Override
    public int jdbcType() {
        return 4;
    }
}

