/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.join;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.mapping.join.AttrNode;
import org.beetl.sql.core.mapping.join.JsonConfigMapper;

public class AutoJsonMapper
extends JsonConfigMapper {
    protected static Map<AutoKey, AttrNode> cache = new ConcurrentHashMap<AutoKey, AttrNode>();

    @Override
    protected AttrNode parse(ExecuteContext ctx, Class target, ResultSetMetaData rsmd, Annotation config) throws Exception {
        NameConversion nc = ctx.sqlManager.getNc();
        AutoKey key = new AutoKey(target, nc);
        AttrNode root = cache.get(key);
        if (root == null) {
            Map<String, Integer> columnIndex = this.getColumnIndex(rsmd);
            CaseInsensitiveHashMap configMap = new CaseInsensitiveHashMap();
            String prefix = "";
            this.getMappingByJson(prefix, nc, (Map<String, Object>)configMap, target);
            root = new AttrNode(null);
            root.initNode(target, (Map<String, Object>)configMap, columnIndex);
            cache.put(key, root);
        }
        return root;
    }

    protected void getMappingByJson(String prefix, NameConversion nc, Map<String, Object> configMap, Class target) throws IntrospectionException {
        PropertyDescriptor[] pds;
        for (PropertyDescriptor pd : pds = BeanKit.propertyDescriptors((Class)target)) {
            Class<?> type = pd.getPropertyType();
            if (type == Class.class) continue;
            String attr = pd.getName();
            String col = nc.getColName(target, attr);
            String configCol = this.getPrefix(prefix, col);
            if (BeanKit.isBaseDataType(type)) {
                configMap.put(attr, configCol);
                continue;
            }
            Class childType = type;
            if (List.class.isAssignableFrom(type)) {
                Class tempType = BeanKit.getParameterTypeClass((Type)pd.getReadMethod().getGenericReturnType());
                childType = tempType == null ? Map.class : tempType;
            }
            HashMap<String, Object> childConfig = new HashMap<String, Object>();
            this.getMappingByJson(configCol, nc, childConfig, childType);
            configMap.put(attr, childConfig);
        }
    }

    protected String getPrefix(String prefix, String col) {
        if (prefix.length() == 0) {
            return col;
        }
        return prefix + "." + col;
    }

    static class AutoKey {
        Class target;
        NameConversion nameConversion;

        public AutoKey(Class target, NameConversion nameConversion) {
            this.target = target;
            this.nameConversion = nameConversion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoKey autoKey = (AutoKey)o;
            return this.target.equals(autoKey.target) && this.nameConversion.equals(autoKey.nameConversion);
        }

        public int hashCode() {
            return Objects.hash(this.target, this.nameConversion);
        }
    }
}

