/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.text.MessageFormat;
import java.util.Map;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.range.RangeSql;

public class DerbyStyle
extends AbstractDBStyle {
    RangeSql rangeSql = new DerbyRowNumRange(this);

    public String getPageSQL(String sql) {
        return sql + this.getOrderBy() + " \nlimit " + this.sqlTemplateEngine.appendVar("_pageOffset") + " , " + this.sqlTemplateEngine.appendVar("_pageSize");
    }

    @Override
    public String getName() {
        return "derby";
    }

    @Override
    public int getDBType() {
        return 20;
    }

    @Override
    public RangeSql getRangeSql() {
        return this.rangeSql;
    }

    public class DerbyRowNumRange
    implements RangeSql {
        AbstractDBStyle dbStyle = null;
        String jdbcTemplate = "SELECT * FROM ( SELECT ROW_NUMBER() OVER() AS beetl_rn, mytable.* FROM ({0}) mytable) AS tmp WHERE beetl_rn <= {1} and beetl_rn>{2}";

        public DerbyRowNumRange(AbstractDBStyle dbStyle) {
            this.dbStyle = dbStyle;
        }

        @Override
        public String toRange(String jdbcSql, Object objOffset, Long limit) {
            Long offset = ((Number)objOffset).longValue();
            offset = PageParamKit.oracleOffset(this.dbStyle.offsetStartZero, offset);
            long pageEnd = PageParamKit.oraclePageEnd(offset, limit);
            String sql = MessageFormat.format(this.jdbcTemplate, jdbcSql, pageEnd, offset);
            return sql;
        }

        @Override
        public String toTemplateRange(Class mapping, String template) {
            String pageSql = MessageFormat.format(this.jdbcTemplate, template, this.dbStyle.appendExpress("_pageEnd"), this.dbStyle.appendExpress("_pageOffset"));
            return pageSql;
        }

        @Override
        public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
            Long offset = (Long)objOffset;
            long s = offset + (long)(this.dbStyle.offsetStartZero ? 1 : 0);
            paras.put("_pageOffset", s);
            paras.put("_pageEnd", s + size);
        }
    }
}

