/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.LinkedHashMap;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.misc.ALU;
import org.beetl.core.statement.BlockStatement;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Statement;

public class SwitchStatement
extends Statement {
    Expression value;
    LinkedHashMap<Expression, BlockStatement> map;
    Expression[] condtionsList;
    BlockStatement[] blocks;
    BlockStatement defaultBlock;

    public SwitchStatement(Expression value, LinkedHashMap<Expression, BlockStatement> map, BlockStatement defaultBlock, GrammarToken token) {
        super(token);
        this.map = map;
        this.value = value;
        this.condtionsList = map.keySet().toArray(new Expression[0]);
        this.blocks = map.values().toArray(new BlockStatement[0]);
        this.defaultBlock = defaultBlock;
    }

    @Override
    public void execute(Context ctx) {
        Object o = this.value.evaluate(ctx);
        if (o == null) {
            BeetlException ex = new BeetlException("NULL");
            ex.pushToken(this.value.token);
            throw ex;
        }
        boolean isMatch = false;
        block10: for (Expression exp : this.condtionsList) {
            if (!isMatch && !ALU.equals(o, exp.evaluate(ctx))) continue;
            isMatch = true;
            BlockStatement block = this.map.get(exp);
            if (block == null) continue;
            block.execute(ctx);
            switch (ctx.gotoFlag) {
                case 0: {
                    continue block10;
                }
                case 3: {
                    return;
                }
                case 2: {
                    ctx.gotoFlag = 0;
                    return;
                }
            }
        }
        if (!isMatch && this.defaultBlock != null) {
            this.defaultBlock.execute(ctx);
            switch (ctx.gotoFlag) {
                case 0: {
                    break;
                }
                case 3: {
                    return;
                }
                case 2: {
                    ctx.gotoFlag = 0;
                    return;
                }
            }
        }
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.value.infer(inferCtx);
        for (Map.Entry<Expression, BlockStatement> entry : this.map.entrySet()) {
            entry.getKey().infer(inferCtx);
            BlockStatement block = entry.getValue();
            if (block == null) continue;
            block.infer(inferCtx);
        }
        if (this.defaultBlock != null) {
            this.defaultBlock.infer(inferCtx);
        }
    }
}

