/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.el.ext.AbstractCallableMethod;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredLazyReferenceSource;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueShadow;
import com.hubspot.jinjava.interpret.DisabledException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.MetaContextVariables;
import com.hubspot.jinjava.interpret.OneTimeReconstructible;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.fn.eager.EagerMacroFunction;
import com.hubspot.jinjava.lib.tag.eager.DeferredToken;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.lib.tag.eager.EagerSetTagStrategy;
import com.hubspot.jinjava.loader.RelativePathResolver;
import com.hubspot.jinjava.objects.serialization.PyishBlockSetSerializable;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import com.hubspot.jinjava.objects.serialization.PyishSerializable;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.output.DynamicRenderedOutputNode;
import com.hubspot.jinjava.tree.output.OutputList;
import com.hubspot.jinjava.tree.output.RenderedOutputNode;
import com.hubspot.jinjava.tree.parse.NoteToken;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import com.hubspot.jinjava.util.EagerContextWatcher;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import com.hubspot.jinjava.util.LengthLimitingStringJoiner;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Beta
public class EagerReconstructionUtils {
    @Deprecated
    public static EagerExecutionResult executeInChildContext(Function<JinjavaInterpreter, EagerExpressionResolver.EagerExpressionResult> function, JinjavaInterpreter interpreter, boolean takeNewValue, boolean partialMacroEvaluation, boolean checkForContextChanges) {
        return EagerReconstructionUtils.executeInChildContext(function, interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withTakeNewValue(takeNewValue).withForceDeferredExecutionMode(checkForContextChanges).withPartialMacroEvaluation(partialMacroEvaluation).build());
    }

    public static EagerExecutionResult executeInChildContext(Function<JinjavaInterpreter, EagerExpressionResolver.EagerExpressionResult> function, JinjavaInterpreter interpreter, EagerContextWatcher.EagerChildContextConfig eagerChildContextConfig) {
        return EagerContextWatcher.executeInChildContext(function, interpreter, eagerChildContextConfig);
    }

    @Deprecated
    public static String reconstructFromContextBeforeDeferring(Set<String> deferredWords, JinjavaInterpreter interpreter) {
        return String.join((CharSequence)"", EagerReconstructionUtils.reconstructFromContextBeforeDeferringAsMap(deferredWords, interpreter).values());
    }

    @Deprecated
    public static PrefixToPreserveState reconstructFromContextBeforeDeferringAsMap(Set<String> deferredWords, JinjavaInterpreter interpreter) {
        PrefixToPreserveState prefixToPreserveState = new PrefixToPreserveState();
        EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, deferredWords, interpreter, 0);
        return prefixToPreserveState;
    }

    public static PrefixToPreserveState hydrateReconstructionFromContextBeforeDeferring(PrefixToPreserveState prefixToPreserveState, Set<String> deferredWords, JinjavaInterpreter interpreter) {
        return EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, deferredWords, interpreter, 0);
    }

    private static PrefixToPreserveState hydrateReconstructionFromContextBeforeDeferring(PrefixToPreserveState prefixToPreserveState, Set<String> deferredWords, JinjavaInterpreter interpreter, int depth) {
        if (depth <= interpreter.getConfig().getMaxRenderDepth()) {
            EagerReconstructionUtils.hydrateReconstructionOfMacroFunctionsBeforeDeferring(prefixToPreserveState, deferredWords, interpreter);
            Set<String> deferredWordBases = EagerReconstructionUtils.filterToRelevantBases(deferredWords, interpreter);
            if (deferredWordBases.isEmpty()) {
                return prefixToPreserveState;
            }
            return EagerReconstructionUtils.hydrateReconstructionOfVariablesBeforeDeferring(prefixToPreserveState, deferredWordBases, interpreter, depth);
        }
        return prefixToPreserveState;
    }

    private static Set<String> filterToRelevantBases(Set<String> deferredWords, JinjavaInterpreter interpreter) {
        Map<String, Object> combinedScope = interpreter.getContext().getCombinedScope();
        Set<String> deferredWordBases = deferredWords.stream().map(w -> w.split("\\.", 2)[0]).filter(combinedScope::containsKey).collect(Collectors.toSet());
        if (interpreter.getContext().isDeferredExecutionMode()) {
            Context parent = interpreter.getContext().getParent();
            while (parent.isDeferredExecutionMode()) {
                parent = parent.getParent();
            }
            Context finalParent = parent;
            deferredWordBases = deferredWordBases.stream().filter(word -> {
                Object parentValue = finalParent.get(word);
                return !(parentValue instanceof DeferredValue) && interpreter.getContext().get(word) != finalParent.get(word);
            }).collect(Collectors.toSet());
        }
        return deferredWordBases;
    }

    private static PrefixToPreserveState hydrateReconstructionOfMacroFunctionsBeforeDeferring(PrefixToPreserveState prefixToPreserveState, Set<String> deferredWords, JinjavaInterpreter interpreter) {
        HashSet toRemove = new HashSet();
        Map macroFunctions = deferredWords.stream().filter(w -> !prefixToPreserveState.containsKey(w)).filter(w -> !interpreter.getContext().containsKey(w)).map(w -> interpreter.getContext().getGlobalMacro((String)w)).filter(Objects::nonNull).filter(macroFunction -> !macroFunction.isCaller()).collect(Collectors.toMap(AbstractCallableMethod::getName, Function.identity()));
        for (String word : deferredWords) {
            if (!word.contains(".")) continue;
            interpreter.getContext().getLocalMacro(word).ifPresent(macroFunction -> macroFunctions.put(word, macroFunction));
        }
        Map<String, String> reconstructedMacros = macroFunctions.entrySet().stream().peek(entry -> toRemove.add((String)entry.getKey())).peek(entry -> ((MacroFunction)entry.getValue()).setDeferred(true)).map(entry -> new AbstractMap.SimpleImmutableEntry<String, EagerExecutionResult>((String)entry.getKey(), EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.EagerExpressionResult.fromString(((EagerMacroFunction)entry.getValue()).reconstructImage((String)entry.getKey())), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withForceDeferredExecutionMode(true).build()))).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((EagerExecutionResult)entry.getValue()).asTemplateString()));
        prefixToPreserveState.withAll(reconstructedMacros);
        deferredWords.removeAll(toRemove);
        return prefixToPreserveState;
    }

    private static PrefixToPreserveState hydrateReconstructionOfVariablesBeforeDeferring(PrefixToPreserveState prefixToPreserveState, Set<String> deferredWords, JinjavaInterpreter interpreter, int depth) {
        deferredWords.stream().filter(w -> !MetaContextVariables.isMetaContextVariable(w, interpreter.getContext())).filter(w -> !prefixToPreserveState.containsKey(w)).map(word -> new AbstractMap.SimpleImmutableEntry((String)word, interpreter.getContext().get(word))).filter(entry -> entry.getValue() != null && !(entry.getValue() instanceof DeferredValue)).forEach(entry -> EagerReconstructionUtils.hydrateBlockOrInlineSetTagRecursively(prefixToPreserveState, (String)entry.getKey(), entry.getValue(), interpreter, depth));
        return prefixToPreserveState;
    }

    public static String buildBlockOrInlineSetTag(String name, Object value, JinjavaInterpreter interpreter) {
        return EagerReconstructionUtils.buildBlockOrInlineSetTag(name, value, interpreter, false);
    }

    public static String buildBlockOrInlineSetTagAndRegisterDeferredToken(String name, Object value, JinjavaInterpreter interpreter) {
        return EagerReconstructionUtils.buildBlockOrInlineSetTag(name, value, interpreter, true);
    }

    public static PrefixToPreserveState hydrateBlockOrInlineSetTagRecursively(PrefixToPreserveState prefixToPreserveState, String name, Object value, JinjavaInterpreter interpreter) {
        return EagerReconstructionUtils.hydrateBlockOrInlineSetTagRecursively(prefixToPreserveState, name, value, interpreter, 0);
    }

    private static PrefixToPreserveState hydrateBlockOrInlineSetTagRecursively(PrefixToPreserveState prefixToPreserveState, String name, Object value, JinjavaInterpreter interpreter, int depth) {
        Set<String> dependentWords;
        if (value instanceof DeferredValue && !(value instanceof PyishBlockSetSerializable) && !(value instanceof PyishSerializable)) {
            value = ((DeferredValue)value).getOriginalValue();
        }
        if (value instanceof PyishBlockSetSerializable) {
            prefixToPreserveState.put(name, EagerReconstructionUtils.buildBlockSetTag(name, ((PyishBlockSetSerializable)value).getBlockSetBody(), interpreter, false));
            return prefixToPreserveState;
        }
        String pyishStringRepresentation = PyishObjectMapper.getAsPyishString(value);
        if (depth < interpreter.getConfig().getMaxRenderDepth() && interpreter.getConfig().isNestedInterpretationEnabled() && !(dependentWords = EagerExpressionResolver.findDeferredWords(pyishStringRepresentation, interpreter)).isEmpty()) {
            EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, dependentWords, interpreter, depth + 1);
        }
        prefixToPreserveState.put(name, EagerReconstructionUtils.buildSetTag((Map<String, String>)ImmutableMap.of((Object)name, (Object)pyishStringRepresentation), interpreter, false));
        return prefixToPreserveState;
    }

    public static String buildBlockOrInlineSetTag(String name, Object value, JinjavaInterpreter interpreter, boolean registerDeferredToken) {
        if (value instanceof DeferredValue && !(value instanceof PyishBlockSetSerializable) && !(value instanceof PyishSerializable)) {
            value = ((DeferredValue)value).getOriginalValue();
        }
        if (value instanceof PyishBlockSetSerializable) {
            return EagerReconstructionUtils.buildBlockSetTag(name, ((PyishBlockSetSerializable)value).getBlockSetBody(), interpreter, registerDeferredToken);
        }
        return EagerReconstructionUtils.buildSetTag((Map<String, String>)ImmutableMap.of((Object)name, (Object)PyishObjectMapper.getAsPyishString(value)), interpreter, registerDeferredToken);
    }

    public static String buildSetTag(Map<String, String> deferredValuesToSet, JinjavaInterpreter interpreter, boolean registerDeferredToken) {
        if (deferredValuesToSet.isEmpty()) {
            return "";
        }
        Map<Context.Library, Set<String>> disabled = interpreter.getConfig().getDisabled();
        if (disabled != null && disabled.containsKey((Object)Context.Library.TAG) && disabled.get((Object)Context.Library.TAG).contains("set")) {
            throw new DisabledException("set tag disabled");
        }
        StringJoiner vars = new StringJoiner(",");
        StringJoiner values = new StringJoiner(",");
        ArrayList<String> varsRequiringSuffix = new ArrayList<String>();
        deferredValuesToSet.forEach((key, value) -> {
            vars.add((CharSequence)key);
            values.add((CharSequence)value);
            if (!MetaContextVariables.isTemporaryImportAlias(value)) {
                varsRequiringSuffix.add((String)key);
            }
        });
        LengthLimitingStringJoiner result = new LengthLimitingStringJoiner(interpreter.getConfig().getMaxOutputSize(), " ");
        result.add(interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag()).add("set").add(vars.toString()).add("=").add(values.toString()).add(interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag());
        String image = result.toString();
        String suffix = EagerSetTagStrategy.getSuffixToPreserveState(varsRequiringSuffix, interpreter);
        if (registerDeferredToken) {
            return String.valueOf((Object)new PrefixToPreserveState(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromImage(image, TagToken.class, interpreter).addSetDeferredWords(deferredValuesToSet.keySet()).build()))) + image + suffix;
        }
        return image + suffix;
    }

    public static String buildBlockSetTag(String name, String value, JinjavaInterpreter interpreter, boolean registerDeferredToken) {
        Map<Context.Library, Set<String>> disabled = interpreter.getConfig().getDisabled();
        if (disabled != null && disabled.containsKey((Object)Context.Library.TAG) && disabled.get((Object)Context.Library.TAG).contains("set")) {
            throw new DisabledException("set tag disabled");
        }
        LengthLimitingStringJoiner blockSetTokenBuilder = new LengthLimitingStringJoiner(interpreter.getConfig().getMaxOutputSize(), " ");
        StringJoiner endTokenBuilder = new StringJoiner(" ");
        blockSetTokenBuilder.add(interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag()).add("set").add(name).add(interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag());
        endTokenBuilder.add(interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag()).add("endset").add(interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag());
        String image = String.valueOf(blockSetTokenBuilder) + value + String.valueOf(endTokenBuilder);
        String suffix = EagerSetTagStrategy.getSuffixToPreserveState(new String[]{name}, interpreter);
        if (registerDeferredToken) {
            return String.valueOf((Object)new PrefixToPreserveState(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromImage(blockSetTokenBuilder.toString(), TagToken.class, interpreter).addSetDeferredWords(Stream.of(name)).build()))) + image + suffix;
        }
        return image + suffix;
    }

    public static String buildDoUpdateTag(String name, String updateString, JinjavaInterpreter interpreter) {
        Map<Context.Library, Set<String>> disabled = interpreter.getConfig().getDisabled();
        if (disabled != null && disabled.containsKey((Object)Context.Library.TAG) && disabled.get((Object)Context.Library.TAG).contains("do")) {
            throw new DisabledException("do tag disabled");
        }
        return new LengthLimitingStringJoiner(interpreter.getConfig().getMaxOutputSize(), " ").add(interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag()).add("do").add(String.format("%s.update(%s)", name, updateString)).add(interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag()).toString();
    }

    public static String reconstructEnd(TagNode tagNode) {
        return String.format("%s %s %s", tagNode.getSymbols().getExpressionStartWithTag(), tagNode.getEndName(), tagNode.getSymbols().getExpressionEndWithTag());
    }

    public static String wrapInRawIfNeeded(String output, JinjavaInterpreter interpreter) {
        if (interpreter.getConfig().getExecutionMode().isPreserveRawTags() && !interpreter.getContext().isUnwrapRawOverride() && (output.contains(interpreter.getConfig().getTokenScannerSymbols().getExpressionStart()) || output.contains(interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag()))) {
            output = EagerReconstructionUtils.wrapInTag(output, "raw", interpreter, false);
        }
        return output;
    }

    public static String wrapInAutoEscapeIfNeeded(String output, JinjavaInterpreter interpreter) {
        if (interpreter.getContext().isAutoEscape() && (interpreter.getContext().getParent() == null || !interpreter.getContext().getParent().isAutoEscape())) {
            output = EagerReconstructionUtils.wrapInTag(output, "autoescape", interpreter, false);
        }
        return output;
    }

    public static String wrapInTag(String body, String tagNameToWrap, JinjavaInterpreter interpreter, boolean registerDeferredToken) {
        Map<Context.Library, Set<String>> disabled = interpreter.getConfig().getDisabled();
        if (disabled != null && disabled.containsKey((Object)Context.Library.TAG) && disabled.get((Object)Context.Library.TAG).contains(tagNameToWrap)) {
            throw new DisabledException(String.format("%s tag disabled", tagNameToWrap));
        }
        StringJoiner startTokenBuilder = new StringJoiner(" ");
        StringJoiner endTokenBuilder = new StringJoiner(" ");
        startTokenBuilder.add(interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag()).add(tagNameToWrap).add(interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag());
        endTokenBuilder.add(interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag()).add("end" + tagNameToWrap).add(interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag());
        String image = String.valueOf(startTokenBuilder) + body + String.valueOf(endTokenBuilder);
        if (registerDeferredToken) {
            EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromImage(startTokenBuilder.toString(), TagToken.class, interpreter).build());
        }
        return image;
    }

    public static String labelWithNotes(String body, String noteIdentifier, JinjavaInterpreter interpreter) {
        return EagerReconstructionUtils.getStartLabel(noteIdentifier, interpreter.getConfig().getTokenScannerSymbols()) + body + EagerReconstructionUtils.getEndLabel(noteIdentifier, interpreter.getConfig().getTokenScannerSymbols());
    }

    public static String getStartLabel(String noteIdentifier, TokenScannerSymbols symbols) {
        StringJoiner stringJoiner = new StringJoiner(" ");
        return stringJoiner.add(symbols.getOpeningComment()).add("Start Label: ").add(noteIdentifier).add(symbols.getClosingComment()).toString();
    }

    public static String getEndLabel(String noteIdentifier, TokenScannerSymbols symbols) {
        StringJoiner stringJoiner = new StringJoiner(" ");
        return stringJoiner.add(symbols.getOpeningComment()).add("End Label: ").add(noteIdentifier).add(symbols.getClosingComment()).toString();
    }

    public static String wrapInChildScope(String toWrap, JinjavaInterpreter interpreter) {
        return String.format("%s for __ignored__ in [0] %s", interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag(), interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag()) + toWrap + String.format("%s endfor %s", interpreter.getConfig().getTokenScannerSymbols().getExpressionStartWithTag(), interpreter.getConfig().getTokenScannerSymbols().getExpressionEndWithTag());
    }

    public static Boolean isDeferredExecutionMode() {
        return JinjavaInterpreter.getCurrentMaybe().map(interpreter -> interpreter.getContext().isDeferredExecutionMode()).orElse(false);
    }

    public static PrefixToPreserveState deferWordsAndReconstructReferences(JinjavaInterpreter interpreter, Set<String> wordsToDefer) {
        if (!wordsToDefer.isEmpty()) {
            wordsToDefer = wordsToDefer.stream().filter(key -> !(interpreter.getContext().get(key) instanceof DeferredValue)).collect(Collectors.toSet());
            PrefixToPreserveState prefixToPreserveState = new PrefixToPreserveState();
            if (!wordsToDefer.isEmpty()) {
                prefixToPreserveState.withAllInFront(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromImage("", NoteToken.class, interpreter).addUsedDeferredWords(wordsToDefer).build()));
            }
            return prefixToPreserveState;
        }
        return new PrefixToPreserveState();
    }

    public static Map<String, String> handleDeferredTokenAndReconstructReferences(JinjavaInterpreter interpreter, DeferredToken deferredToken) {
        deferredToken.addTo(interpreter.getContext());
        return EagerReconstructionUtils.reconstructDeferredReferences(interpreter, deferredToken.getUsedDeferredWords());
    }

    public static Map<String, String> reconstructDeferredReferences(JinjavaInterpreter interpreter, Set<String> usedDeferredWords) {
        return interpreter.getContext().getScope().entrySet().stream().filter(entry -> entry.getValue() instanceof OneTimeReconstructible && !((OneTimeReconstructible)entry.getValue()).isReconstructed()).filter(entry -> entry.getValue() instanceof DeferredLazyReferenceSource || usedDeferredWords.contains(entry.getKey())).peek(entry -> ((OneTimeReconstructible)entry.getValue()).setReconstructed(true)).map(entry -> new AbstractMap.SimpleImmutableEntry<String, String>((String)entry.getKey(), PyishObjectMapper.getAsPyishString(((DeferredValue)entry.getValue()).getOriginalValue()))).sorted((a, b) -> ((String)a.getValue()).equals(b.getKey()) ? 1 : (((String)b.getValue()).equals(a.getKey()) ? -1 : 0)).collect(Collectors.toMap(Map.Entry::getKey, entry -> EagerReconstructionUtils.buildSetTag(Collections.singletonMap((String)entry.getKey(), (String)entry.getValue()), interpreter, false), (a, b) -> b, LinkedHashMap::new));
    }

    public static PrefixToPreserveState resetAndDeferSpeculativeBindings(JinjavaInterpreter interpreter, EagerExecutionResult eagerExecutionResult) {
        return EagerReconstructionUtils.deferWordsAndReconstructReferences(interpreter, EagerReconstructionUtils.resetSpeculativeBindings(interpreter, eagerExecutionResult));
    }

    public static Set<String> resetSpeculativeBindings(JinjavaInterpreter interpreter, EagerExecutionResult result) {
        result.getSpeculativeBindings().forEach((k, v) -> {
            if (v instanceof DeferredValue) {
                v = ((DeferredValue)v).getOriginalValue();
            }
            EagerReconstructionUtils.replace(interpreter.getContext(), k, v);
        });
        return result.getSpeculativeBindings().keySet();
    }

    private static void replace(Context context, String k, Object v) {
        if (context == null) {
            return;
        }
        Object replaced = context.getScope().replace(k, v);
        if (replaced == null) {
            EagerReconstructionUtils.replace(context.getParent(), k, v);
        } else if (replaced instanceof DeferredValueShadow) {
            context.getScope().remove(k);
            EagerReconstructionUtils.replace(context.getParent(), k, v);
        }
    }

    public static void commitSpeculativeBindings(JinjavaInterpreter interpreter, EagerExecutionResult result) {
        result.getSpeculativeBindings().entrySet().stream().filter(entry -> !(entry.getValue() instanceof DeferredValueShadow)).forEach(entry -> interpreter.getContext().put((String)entry.getKey(), entry.getValue()));
    }

    public static void reconstructPathAroundBlock(DynamicRenderedOutputNode prefix, OutputList blockValueBuilder, JinjavaInterpreter interpreter) {
        String blockPath = RelativePathResolver.getCurrentPathFromStackOrKey(interpreter);
        String tempVarName = MetaContextVariables.getTemporaryCurrentPathVarName(blockPath);
        prefix.setValue(EagerReconstructionUtils.buildSetTag((Map<String, String>)ImmutableMap.of((Object)tempVarName, (Object)"current_path", (Object)"current_path", (Object)PyishObjectMapper.getAsPyishString(blockPath)), interpreter, false));
        blockValueBuilder.addNode(new RenderedOutputNode(EagerReconstructionUtils.buildSetTag((Map<String, String>)ImmutableMap.of((Object)"current_path", (Object)tempVarName, (Object)tempVarName, (Object)"null"), interpreter, false)));
    }

    public static String wrapPathAroundText(String text, String newPath, JinjavaInterpreter interpreter) {
        String tempVarName = MetaContextVariables.getTemporaryCurrentPathVarName(newPath);
        return EagerReconstructionUtils.buildSetTag((Map<String, String>)ImmutableMap.of((Object)tempVarName, (Object)"current_path", (Object)"current_path", (Object)PyishObjectMapper.getAsPyishString(newPath)), interpreter, false) + text + EagerReconstructionUtils.buildSetTag((Map<String, String>)ImmutableMap.of((Object)"current_path", (Object)tempVarName, (Object)tempVarName, (Object)"null"), interpreter, false);
    }
}

