/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree.output;

import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.OutputTooBigException;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.tree.output.BlockPlaceholderOutputNode;
import com.hubspot.jinjava.tree.output.OutputNode;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import java.util.LinkedList;
import java.util.List;

public class OutputList {
    public static final String PREVENT_ACCIDENTAL_EXPRESSIONS = "PREVENT_ACCIDENTAL_EXPRESSIONS";
    private final List<OutputNode> nodes = new LinkedList<OutputNode>();
    private final List<BlockPlaceholderOutputNode> blocks = new LinkedList<BlockPlaceholderOutputNode>();
    private final long maxOutputSize;
    private long currentSize;

    public OutputList(long maxOutputSize) {
        this.maxOutputSize = maxOutputSize;
    }

    public void addNode(OutputNode node) {
        if (this.maxOutputSize > 0L && this.currentSize + node.getSize() > this.maxOutputSize) {
            throw new OutputTooBigException(this.maxOutputSize, this.currentSize + node.getSize());
        }
        this.currentSize += node.getSize();
        this.nodes.add(node);
        if (node instanceof BlockPlaceholderOutputNode) {
            BlockPlaceholderOutputNode blockNode = (BlockPlaceholderOutputNode)node;
            if (this.maxOutputSize > 0L && this.currentSize + blockNode.getSize() > this.maxOutputSize) {
                throw new OutputTooBigException(this.maxOutputSize, this.currentSize + blockNode.getSize());
            }
            this.currentSize += blockNode.getSize();
            this.blocks.add(blockNode);
        }
    }

    public List<OutputNode> getNodes() {
        return this.nodes;
    }

    public List<BlockPlaceholderOutputNode> getBlocks() {
        return this.blocks;
    }

    public String getValue() {
        LengthLimitingStringBuilder val = new LengthLimitingStringBuilder(this.maxOutputSize);
        return JinjavaInterpreter.getCurrentMaybe().map(JinjavaInterpreter::getConfig).filter(config -> config.getFeatures().getActivationStrategy(PREVENT_ACCIDENTAL_EXPRESSIONS).isActive(null)).map(config -> this.joinNodesWithoutAddingExpressions(val, config.getTokenScannerSymbols())).orElseGet(() -> this.joinNodes(val));
    }

    private String joinNodesWithoutAddingExpressions(LengthLimitingStringBuilder val, TokenScannerSymbols tokenScannerSymbols) {
        String separator = OutputList.getWhitespaceSeparator(tokenScannerSymbols);
        String prev = null;
        for (OutputNode node : this.nodes) {
            try {
                String cur = node.getValue();
                if (prev != null && prev.length() > 0 && prev.charAt(prev.length() - 1) == tokenScannerSymbols.getExprStartChar() && cur.length() > 0 && TokenScannerSymbols.isNoteTagOrExprChar(tokenScannerSymbols, cur.charAt(0))) {
                    val.append(separator);
                }
                prev = cur;
                val.append(node.getValue());
            }
            catch (OutputTooBigException e) {
                JinjavaInterpreter.getCurrent().addError(TemplateError.fromOutputTooBigException(e));
                return val.toString();
            }
        }
        return val.toString();
    }

    private static String getWhitespaceSeparator(TokenScannerSymbols tokenScannerSymbols) {
        String separator = "" + '\n' + tokenScannerSymbols.getPrefixChar() + tokenScannerSymbols.getNoteChar() + tokenScannerSymbols.getTrimChar() + ' ' + tokenScannerSymbols.getNoteChar() + tokenScannerSymbols.getExprEndChar();
        return separator;
    }

    private String joinNodes(LengthLimitingStringBuilder val) {
        for (OutputNode node : this.nodes) {
            try {
                val.append(node.getValue());
            }
            catch (OutputTooBigException e) {
                JinjavaInterpreter.getCurrent().addError(TemplateError.fromOutputTooBigException(e));
                return val.toString();
            }
        }
        return val.toString();
    }

    public String toString() {
        return this.getValue();
    }
}

