/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.serialization;

import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.annotations.Beta;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.objects.PyWrapper;
import com.hubspot.jinjava.objects.serialization.PyishCharacterEscapes;
import com.hubspot.jinjava.objects.serialization.PyishPrettyPrinter;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

@Beta
public interface PyishSerializable
extends PyWrapper {
    public static final ObjectWriter SELF_WRITER = new ObjectMapper(new JsonFactoryBuilder().quoteChar('\'').build()).registerModule((Module)new Jdk8Module()).writer((PrettyPrinter)PyishPrettyPrinter.INSTANCE).with((CharacterEscapes)PyishCharacterEscapes.INSTANCE);

    default public <T extends Appendable & CharSequence> T appendPyishString(T appendable) throws IOException {
        return (T)appendable.append(PyishSerializable.writeValueAsString(this));
    }

    default public void writePyishSelf(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        AtomicInteger remainingLength = (AtomicInteger)serializerProvider.getAttribute((Object)"remainingLength");
        jsonGenerator.writeRawValue(((Serializable)this.appendPyishString(remainingLength == null ? new StringBuilder() : new LengthLimitingStringBuilder(remainingLength.get()))).toString());
    }

    public static String writeValueAsString(Object value) {
        try {
            return SELF_WRITER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            if (e.getCause() instanceof DeferredValueException) {
                throw (DeferredValueException)e.getCause();
            }
            return "'" + Objects.toString(value) + "'";
        }
    }
}

