/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.annotations.Beta;
import com.hubspot.jinjava.objects.serialization.LengthLimitingWriter;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Beta
public class MapEntrySerializer
extends JsonSerializer<Map.Entry<?, ?>> {
    public static final MapEntrySerializer INSTANCE = new MapEntrySerializer();

    private MapEntrySerializer() {
    }

    public void serialize(Map.Entry<?, ?> entry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        String value;
        String key;
        AtomicInteger remainingLength = (AtomicInteger)serializerProvider.getAttribute((Object)"remainingLength");
        ObjectWriter objectWriter = PyishObjectMapper.PYISH_OBJECT_WRITER.withAttribute((Object)"allowSnakeCase", serializerProvider.getAttribute((Object)"allowSnakeCase"));
        if (remainingLength != null) {
            objectWriter = objectWriter.withAttribute((Object)"remainingLength", (Object)remainingLength);
            key = objectWriter.writeValueAsString(entry.getKey());
            LengthLimitingWriter lengthLimitingWriter = new LengthLimitingWriter(new CharArrayWriter(), remainingLength);
            objectWriter.writeValue((Writer)lengthLimitingWriter, entry.getValue());
            value = lengthLimitingWriter.toString();
        } else {
            key = objectWriter.writeValueAsString(entry.getKey());
            value = objectWriter.writeValueAsString(entry.getValue());
        }
        jsonGenerator.writeRawValue(String.format("fn:map_entry(%s, %s)", key, value));
    }
}

