/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.collections;

import com.google.common.collect.ForwardingList;
import com.hubspot.jinjava.interpret.IndexOutOfRangeException;
import com.hubspot.jinjava.objects.PyWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PyList
extends ForwardingList<Object>
implements PyWrapper {
    private boolean computingHashCode = false;
    private final List<Object> list;

    public PyList(List<Object> list) {
        this.list = list;
    }

    protected List<Object> delegate() {
        return this.list;
    }

    public List<Object> toList() {
        return this.list;
    }

    public boolean append(Object e) {
        if (this == e) {
            return false;
        }
        return this.add(e);
    }

    public void insert(int i, Object e) {
        if (this == e) {
            return;
        }
        if (i >= this.list.size()) {
            throw this.createOutOfRangeException(i);
        }
        if (i < 0) {
            i = Math.max(0, this.list.size() + i);
        }
        this.add(i, e);
    }

    public boolean extend(PyList e) {
        return e != null && this.addAll(e.list);
    }

    public Object pop() {
        if (this.list.size() == 0) {
            throw this.createOutOfRangeException(0);
        }
        return this.remove(this.list.size() - 1);
    }

    public Object pop(int index) {
        if (Math.abs(index) >= this.list.size()) {
            throw this.createOutOfRangeException(index);
        }
        if (index < 0) {
            index = this.list.size() + index;
        }
        return this.remove(index);
    }

    public long count(Object o) {
        return this.stream().filter(object -> Objects.equals(object, o)).count();
    }

    public void reverse() {
        Collections.reverse(this.list);
    }

    public PyList copy() {
        return new PyList(new ArrayList<Object>(this.list));
    }

    public int index(Object o) {
        return this.indexOf(o);
    }

    public Object get(int index) {
        if (index < 0 || index >= this.list.size()) {
            throw this.createOutOfRangeException(index);
        }
        return super.get(index);
    }

    public int index(Object o, int begin, int end) {
        for (int i = begin; i < end; ++i) {
            if (!Objects.equals(o, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    IndexOutOfRangeException createOutOfRangeException(int index) {
        return new IndexOutOfRangeException(String.format("Index %d is out of range for list of size %d", index, this.list.size()));
    }

    public int hashCode() {
        if (this.computingHashCode) {
            return Objects.hashCode(null);
        }
        try {
            this.computingHashCode = true;
            int n = super.hashCode();
            return n;
        }
        finally {
            this.computingHashCode = false;
        }
    }
}

