/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.loader;

import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.loader.LocationResolver;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RelativePathResolver
implements LocationResolver {
    public static final String CURRENT_PATH_CONTEXT_KEY = "current_path";

    @Override
    public String resolve(String path, JinjavaInterpreter interpreter) {
        if (path.startsWith("./") || path.startsWith("../")) {
            Path folderPath;
            String parentPath = RelativePathResolver.getCurrentPathFromStackOrKey(interpreter);
            Path templatePath = Paths.get(parentPath, new String[0]);
            Path path2 = folderPath = templatePath.getParent() != null ? templatePath.getParent() : Paths.get("", new String[0]);
            if (folderPath != null) {
                return folderPath.resolve(path).normalize().toString();
            }
        }
        return path;
    }

    public static String getCurrentPathFromStackOrKey(JinjavaInterpreter interpreter) {
        return interpreter.getContext().getCurrentPathStack().peek().orElseGet(() -> interpreter.getContext().getOrDefault(CURRENT_PATH_CONTEXT_KEY, ""));
    }
}

