/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager.importing;

import com.google.common.annotations.VisibleForTesting;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.MetaContextVariables;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.ImportTag;
import com.hubspot.jinjava.lib.tag.eager.importing.EagerImportingStrategy;
import com.hubspot.jinjava.lib.tag.eager.importing.ImportingData;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import java.util.Map;
import java.util.stream.Collectors;

public class FlatEagerImportingStrategy
implements EagerImportingStrategy {
    private final ImportingData importingData;

    @VisibleForTesting
    public FlatEagerImportingStrategy(ImportingData importingData) {
        this.importingData = importingData;
    }

    @Override
    public String handleDeferredTemplateFile(DeferredValueException e) {
        throw e;
    }

    @Override
    public void setup(JinjavaInterpreter child) {
    }

    @Override
    public void integrateChild(JinjavaInterpreter child) {
        JinjavaInterpreter parent = this.importingData.getOriginalInterpreter();
        for (MacroFunction macro : child.getContext().getGlobalMacros().values()) {
            if (!parent.getContext().isDeferredExecutionMode()) continue;
            macro.setDeferred(true);
        }
        for (MacroFunction macro : child.getContext().getGlobalMacros().values()) {
            parent.getContext().addGlobalMacro(macro);
        }
        Map<String, Object> childBindings = child.getContext().getSessionBindings();
        childBindings.remove("__macros__");
        childBindings.remove("import_resource_alias");
        Map<String, Object> childBindingsWithoutImportResourcePath = ImportTag.getChildBindingsWithoutImportResourcePath(childBindings);
        if (parent.getContext().isDeferredExecutionMode()) {
            childBindingsWithoutImportResourcePath.keySet().forEach(key -> parent.getContext().put(key, DeferredValue.instance(parent.getContext().get(key))));
        } else {
            parent.getContext().putAll(childBindingsWithoutImportResourcePath);
        }
    }

    @Override
    public String getFinalOutput(String output, JinjavaInterpreter child) {
        if (this.importingData.getOriginalInterpreter().getContext().isDeferredExecutionMode()) {
            Context context = this.importingData.getOriginalInterpreter().getContext();
            EagerReconstructionUtils.buildSetTag(child.getContext().getSessionBindings().entrySet().stream().filter(entry -> !(entry.getValue() instanceof DeferredValue) && entry.getValue() != null).filter(entry -> !MetaContextVariables.isMetaContextVariable((String)entry.getKey(), context)).collect(Collectors.toMap(Map.Entry::getKey, entry -> "")), this.importingData.getOriginalInterpreter(), true);
        }
        return EagerImportingStrategy.getSetTagForDeferredChildBindings(this.importingData.getOriginalInterpreter(), null, child.getContext().getSessionBindings()) + output;
    }
}

