/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager.importing;

import com.google.common.base.Strings;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.tag.ImportTag;
import com.hubspot.jinjava.lib.tag.eager.importing.AliasedEagerImportingStrategy;
import com.hubspot.jinjava.lib.tag.eager.importing.EagerImportingStrategy;
import com.hubspot.jinjava.lib.tag.eager.importing.FlatEagerImportingStrategy;
import com.hubspot.jinjava.lib.tag.eager.importing.ImportingData;
import com.hubspot.jinjava.loader.RelativePathResolver;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import java.util.List;

public class EagerImportingStrategyFactory {
    public static ImportingData getImportingData(TagToken tagToken, JinjavaInterpreter interpreter) {
        List<String> helpers = ImportTag.getHelpers(tagToken);
        String initialPathSetter = EagerImportingStrategyFactory.getSetTagForCurrentPath(interpreter);
        return new ImportingData(interpreter, tagToken, helpers, initialPathSetter);
    }

    public static EagerImportingStrategy create(ImportingData importingData) {
        String currentImportAlias = ImportTag.getContextVar(importingData.getHelpers());
        if (Strings.isNullOrEmpty((String)currentImportAlias)) {
            return new FlatEagerImportingStrategy(importingData);
        }
        return new AliasedEagerImportingStrategy(importingData, currentImportAlias);
    }

    public static String getSetTagForCurrentPath(JinjavaInterpreter interpreter) {
        return EagerReconstructionUtils.buildBlockOrInlineSetTag("current_path", RelativePathResolver.getCurrentPathFromStackOrKey(interpreter), interpreter);
    }
}

