/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.hubspot.jinjava.lib.tag.BlockTag;
import com.hubspot.jinjava.lib.tag.BreakTag;
import com.hubspot.jinjava.lib.tag.CallTag;
import com.hubspot.jinjava.lib.tag.ContinueTag;
import com.hubspot.jinjava.lib.tag.CycleTag;
import com.hubspot.jinjava.lib.tag.DoTag;
import com.hubspot.jinjava.lib.tag.ElseIfTag;
import com.hubspot.jinjava.lib.tag.ElseTag;
import com.hubspot.jinjava.lib.tag.EndTag;
import com.hubspot.jinjava.lib.tag.ExtendsTag;
import com.hubspot.jinjava.lib.tag.ForTag;
import com.hubspot.jinjava.lib.tag.FromTag;
import com.hubspot.jinjava.lib.tag.IfTag;
import com.hubspot.jinjava.lib.tag.ImportTag;
import com.hubspot.jinjava.lib.tag.IncludeTag;
import com.hubspot.jinjava.lib.tag.MacroTag;
import com.hubspot.jinjava.lib.tag.PrintTag;
import com.hubspot.jinjava.lib.tag.RawTag;
import com.hubspot.jinjava.lib.tag.SetTag;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.lib.tag.UnlessTag;
import com.hubspot.jinjava.lib.tag.eager.EagerCallTag;
import com.hubspot.jinjava.lib.tag.eager.EagerCycleTag;
import com.hubspot.jinjava.lib.tag.eager.EagerDoTag;
import com.hubspot.jinjava.lib.tag.eager.EagerForTag;
import com.hubspot.jinjava.lib.tag.eager.EagerFromTag;
import com.hubspot.jinjava.lib.tag.eager.EagerGenericTag;
import com.hubspot.jinjava.lib.tag.eager.EagerIfTag;
import com.hubspot.jinjava.lib.tag.eager.EagerImportTag;
import com.hubspot.jinjava.lib.tag.eager.EagerIncludeTag;
import com.hubspot.jinjava.lib.tag.eager.EagerMacroTag;
import com.hubspot.jinjava.lib.tag.eager.EagerPrintTag;
import com.hubspot.jinjava.lib.tag.eager.EagerSetTag;
import com.hubspot.jinjava.lib.tag.eager.EagerTagDecorator;
import com.hubspot.jinjava.lib.tag.eager.EagerUnlessTag;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Beta
public class EagerTagFactory {
    public static final Map<Class<? extends Tag>, Class<? extends EagerTagDecorator<? extends Tag>>> EAGER_TAG_OVERRIDES = ImmutableMap.builder().put(SetTag.class, EagerSetTag.class).put(DoTag.class, EagerDoTag.class).put(PrintTag.class, EagerPrintTag.class).put(FromTag.class, EagerFromTag.class).put(ImportTag.class, EagerImportTag.class).put(IncludeTag.class, EagerIncludeTag.class).put(ForTag.class, EagerForTag.class).put(CycleTag.class, EagerCycleTag.class).put(IfTag.class, EagerIfTag.class).put(UnlessTag.class, EagerUnlessTag.class).put(CallTag.class, EagerCallTag.class).build();
    public static final Set<Class<? extends Tag>> TAG_CLASSES_TO_SKIP = ImmutableSet.builder().add(BlockTag.class).add(EndTag.class).add(ElseIfTag.class).add(ElseTag.class).add(RawTag.class).add(ExtendsTag.class).add(BreakTag.class).add(ContinueTag.class).build();

    public static <T extends Tag> Optional<EagerTagDecorator<T>> getEagerTagDecorator(T tag) {
        Class<?> clazz = tag.getClass();
        try {
            EagerTagDecorator<? extends Tag> decorator;
            if (TAG_CLASSES_TO_SKIP.contains(clazz)) {
                return Optional.empty();
            }
            Class<? extends EagerTagDecorator<? extends Tag>> eagerOverrideClass = EAGER_TAG_OVERRIDES.get(clazz);
            if (eagerOverrideClass != null && (decorator = eagerOverrideClass.getDeclaredConstructor(clazz).newInstance(tag)).getTag().getClass() == clazz) {
                return Optional.of(decorator);
            }
            if (tag instanceof MacroTag) {
                return Optional.of(new EagerGenericTag<EagerMacroTag>(new EagerMacroTag()));
            }
            return Optional.of(new EagerGenericTag<T>(tag));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

