/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.google.common.annotations.Beta;
import com.hubspot.jinjava.el.ext.DeferredParsingException;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.OutputTooBigException;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.lib.tag.eager.DeferredToken;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.util.EagerContextWatcher;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import com.hubspot.jinjava.util.LengthLimitingStringJoiner;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import org.apache.commons.lang3.StringUtils;

@Beta
public abstract class EagerTagDecorator<T extends Tag>
implements Tag {
    private final T tag;

    public EagerTagDecorator(T tag) {
        this.tag = tag;
    }

    public T getTag() {
        return this.tag;
    }

    @Override
    public final String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        try {
            String output;
            try {
                output = this.innerInterpret(tagNode, interpreter);
            }
            catch (DeferredValueException | TemplateSyntaxException e) {
                return this.wrapEagerInterpret(tagNode, interpreter, e);
            }
            if (JinjavaInterpreter.isOutputTooLarge(output)) {
                return this.wrapEagerInterpret(tagNode, interpreter, null);
            }
            return output;
        }
        catch (OutputTooBigException e) {
            throw new DeferredValueException(String.format("Output too big for eager execution: %s", e.getMessage()));
        }
    }

    private String wrapEagerInterpret(TagNode tagNode, JinjavaInterpreter interpreter, RuntimeException e) {
        return EagerReconstructionUtils.wrapInAutoEscapeIfNeeded(this.eagerInterpret(tagNode, interpreter, e instanceof InterpretException ? (InterpretException)e : new InterpretException("Exception with default render", e)), interpreter);
    }

    protected String innerInterpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        return this.tag.interpret(tagNode, interpreter);
    }

    @Override
    public String getName() {
        return this.tag.getName();
    }

    @Override
    public String getEndTagName() {
        return this.tag.getEndTagName();
    }

    @Override
    public boolean isRenderedInValidationMode() {
        return this.tag.isRenderedInValidationMode();
    }

    public String eagerInterpret(TagNode tagNode, JinjavaInterpreter interpreter, InterpretException e) {
        LengthLimitingStringBuilder result = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
        result.append(EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.EagerExpressionResult.fromString(this.getEagerImage(this.buildToken(tagNode, e, interpreter.getLineNumber(), interpreter.getPosition()), (JinjavaInterpreter)eagerInterpreter) + this.renderChildren(tagNode, (JinjavaInterpreter)eagerInterpreter)), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withForceDeferredExecutionMode(true).build()).asTemplateString());
        if (StringUtils.isNotBlank((CharSequence)tagNode.getEndName())) {
            result.append(EagerReconstructionUtils.reconstructEnd(tagNode));
        }
        return result.toString();
    }

    public TagToken buildToken(TagNode tagNode, InterpretException e, int deferredLineNumber, int deferredPosition) {
        if (e instanceof DeferredParsingException && deferredLineNumber == tagNode.getLineNumber() && deferredPosition == tagNode.getStartPosition()) {
            return new TagToken(String.format("%s %s %s %s", tagNode.getSymbols().getExpressionStartWithTag(), tagNode.getName(), ((DeferredParsingException)e).getDeferredEvalResult(), tagNode.getSymbols().getExpressionEndWithTag()), tagNode.getLineNumber(), tagNode.getStartPosition(), tagNode.getSymbols());
        }
        return (TagToken)tagNode.getMaster();
    }

    public String renderChildren(TagNode tagNode, JinjavaInterpreter interpreter) {
        StringBuilder sb = new StringBuilder();
        for (Node child : tagNode.getChildren()) {
            sb.append(child.render(interpreter).getValue());
        }
        return sb.toString();
    }

    public final String getEagerImage(Token token, JinjavaInterpreter interpreter) {
        interpreter.setLineNumber(token.getLineNumber());
        if (!(token instanceof TagToken)) {
            throw new DeferredValueException("Unsupported Token type");
        }
        String eagerImage = this.getEagerTagImage((TagToken)token, interpreter);
        return eagerImage;
    }

    public String getEagerTagImage(TagToken tagToken, JinjavaInterpreter interpreter) {
        LengthLimitingStringJoiner joiner = new LengthLimitingStringJoiner(interpreter.getConfig().getMaxOutputSize(), " ");
        joiner.add(tagToken.getSymbols().getExpressionStartWithTag()).add(tagToken.getTagName());
        EagerExpressionResolver.EagerExpressionResult eagerExpressionResult = EagerExpressionResolver.resolveExpression(tagToken.getHelpers().trim(), interpreter);
        String resolvedString = eagerExpressionResult.toString();
        if (StringUtils.isNotBlank((CharSequence)resolvedString)) {
            joiner.add(resolvedString);
        }
        joiner.add(tagToken.getSymbols().getExpressionEndWithTag());
        PrefixToPreserveState prefixToPreserveState = new PrefixToPreserveState();
        EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, eagerExpressionResult.getDeferredWords(), interpreter);
        prefixToPreserveState.withAllInFront(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromImage(joiner.toString(), tagToken).addUsedDeferredWords(eagerExpressionResult.getDeferredWords()).build()));
        return String.valueOf((Object)prefixToPreserveState) + joiner.toString();
    }
}

