/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.google.common.annotations.Beta;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.MetaContextVariables;
import com.hubspot.jinjava.lib.tag.SetTag;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Triple;

@Beta
public abstract class EagerSetTagStrategy {
    protected final SetTag setTag;

    protected EagerSetTagStrategy(SetTag setTag) {
        this.setTag = setTag;
    }

    public String run(TagNode tagNode, JinjavaInterpreter interpreter) {
        String expression;
        String[] variables;
        int eqPos = tagNode.getHelpers().indexOf(61);
        if (eqPos > 0) {
            variables = tagNode.getHelpers().substring(0, eqPos).trim().split(",");
            expression = tagNode.getHelpers().substring(eqPos + 1).trim();
        } else {
            int filterPos = tagNode.getHelpers().indexOf(124);
            String var = tagNode.getHelpers().trim();
            if (filterPos >= 0) {
                var = tagNode.getHelpers().substring(0, filterPos).trim();
            }
            variables = new String[]{var};
            expression = tagNode.getHelpers();
        }
        interpreter.getContext().addNonMetaContextVariables(Arrays.stream(variables).map(String::trim).collect(Collectors.toList()));
        EagerExecutionResult eagerExecutionResult = this.getEagerExecutionResult(tagNode, variables, expression, interpreter);
        boolean triedResolve = false;
        if (eagerExecutionResult.getResult().isFullyResolved() && !interpreter.getContext().isDeferredExecutionMode() && (Arrays.stream(variables).noneMatch("current_path"::equals) || interpreter.getContext().getPenultimateParent().getDeferredTokens().isEmpty())) {
            EagerReconstructionUtils.commitSpeculativeBindings(interpreter, eagerExecutionResult);
            Optional<String> maybeResolved = this.resolveSet(tagNode, variables, eagerExecutionResult, interpreter);
            triedResolve = true;
            if (maybeResolved.isPresent()) {
                return maybeResolved.get();
            }
        }
        Triple<String, String, String> triple = this.getPrefixTokenAndSuffix(tagNode, variables, eagerExecutionResult, interpreter);
        if (eagerExecutionResult.getResult().isFullyResolved() && !triedResolve) {
            this.attemptResolve(tagNode, variables, eagerExecutionResult, interpreter);
        }
        return this.buildImage(tagNode, variables, eagerExecutionResult, triple, interpreter);
    }

    protected abstract EagerExecutionResult getEagerExecutionResult(TagNode var1, String[] var2, String var3, JinjavaInterpreter var4);

    protected abstract Optional<String> resolveSet(TagNode var1, String[] var2, EagerExecutionResult var3, JinjavaInterpreter var4);

    protected abstract Triple<String, String, String> getPrefixTokenAndSuffix(TagNode var1, String[] var2, EagerExecutionResult var3, JinjavaInterpreter var4);

    protected abstract void attemptResolve(TagNode var1, String[] var2, EagerExecutionResult var3, JinjavaInterpreter var4);

    protected abstract String buildImage(TagNode var1, String[] var2, EagerExecutionResult var3, Triple<String, String, String> var4, JinjavaInterpreter var5);

    protected PrefixToPreserveState getPrefixToPreserveState(EagerExecutionResult eagerExecutionResult, String[] variables, JinjavaInterpreter interpreter) {
        PrefixToPreserveState prefixToPreserveState = new PrefixToPreserveState();
        if (!eagerExecutionResult.getResult().isFullyResolved() || interpreter.getContext().isDeferredExecutionMode()) {
            prefixToPreserveState.putAll((Map)((Object)eagerExecutionResult.getPrefixToPreserveState()));
        } else {
            EagerReconstructionUtils.commitSpeculativeBindings(interpreter, eagerExecutionResult);
        }
        EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, eagerExecutionResult.getResult().getDeferredWords(), interpreter);
        EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, Arrays.stream(variables).filter(var -> var.contains(".")).collect(Collectors.toSet()), interpreter);
        return prefixToPreserveState;
    }

    public static String getSuffixToPreserveState(List<String> varList, JinjavaInterpreter interpreter) {
        if (varList.isEmpty()) {
            return "";
        }
        return EagerSetTagStrategy.getSuffixToPreserveState(varList.stream(), interpreter);
    }

    public static String getSuffixToPreserveState(String[] varList, JinjavaInterpreter interpreter) {
        if (varList.length == 0) {
            return "";
        }
        return EagerSetTagStrategy.getSuffixToPreserveState(Arrays.stream(varList), interpreter);
    }

    private static String getSuffixToPreserveState(Stream<String> varStream, JinjavaInterpreter interpreter) {
        StringBuilder suffixToPreserveState = new StringBuilder();
        Optional<String> maybeTemporaryImportAlias = interpreter.getContext().getImportResourceAlias().map(MetaContextVariables::getTemporaryImportAlias);
        if (maybeTemporaryImportAlias.isPresent()) {
            boolean stillInsideImportTag = interpreter.getContext().containsKey(maybeTemporaryImportAlias.get());
            List<String> filteredVars = varStream.filter(var -> !MetaContextVariables.isMetaContextVariable(var, interpreter.getContext())).peek(var -> {
                if (!stillInsideImportTag && interpreter.retraceVariable(String.format("%s.%s", interpreter.getContext().getImportResourceAlias().get(), var), -1) != null) {
                    throw new DeferredValueException("Cannot modify temporary import alias outside of import tag");
                }
            }).collect(Collectors.toList());
            if (filteredVars.isEmpty()) {
                return "";
            }
            String updateString = EagerSetTagStrategy.getUpdateString(filteredVars);
            suffixToPreserveState.append(EagerReconstructionUtils.buildDoUpdateTag(maybeTemporaryImportAlias.get(), updateString, interpreter));
        }
        return suffixToPreserveState.toString();
    }

    private static String getUpdateString(List<String> varList) {
        StringJoiner updateString = new StringJoiner(",");
        varList.forEach(var -> updateString.add(String.format("'%s': %s", var, var)));
        return "{" + String.valueOf(updateString) + "}";
    }
}

